  const images = [
    { color: 'assets/img/img-works-1.png', bw: 'assets/img/img-works-bnw-1.png' },
    { color: 'assets/img/img-works-2.png', bw: 'assets/img/img-works-bnw-2.png' },
    { color: 'assets/img/img-works-3.png', bw: 'assets/img/img-works-bnw-3.png' }
  ];

  let currentIndex = 1;

  function initCarousel() {
    renderCarousel();
  }

  function renderCarousel() {
    const container = document.getElementById('carouselContainer');
    container.innerHTML = '';

    const leftIndex = (currentIndex - 1 + images.length) % images.length;
    const centerIndex = currentIndex;
    const rightIndex = (currentIndex + 1) % images.length;

    const leftItem = createCarouselItem(images[leftIndex].bw, 'side');
    container.appendChild(leftItem);

    const centerItem = createCarouselItem(images[centerIndex].color, 'center');
    container.appendChild(centerItem);

    const rightItem = createCarouselItem(images[rightIndex].bw, 'side');
    container.appendChild(rightItem);
  }

  function createCarouselItem(src, type) {
  const item = document.createElement('div');
  item.className = `carousel-item ${type}`;

  // Apply Tailwind classes based on type
  if (type === 'center') {
    item.classList.add('flex-[2]', 'mx-[50px]', 'transition-shadow', 'duration-300', 'hover:shadow-[0_0_20px_2px_rgba(134,183,232,0.7)]');
  } else {
    item.classList.add('flex-1', 'opacity-60');
  }

  const img = document.createElement('img');
  img.src = src;
  img.alt = 'Tattoo Work';
  img.className = 'w-full h-full object-cover';

  item.appendChild(img);
  return item;
}


  function moveCarousel(direction) {
    currentIndex = (currentIndex + direction + images.length) % images.length;
    renderCarousel();
  }

  window.addEventListener('load', initCarousel);