<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use Illuminate\Http\Request;

class BannerController extends Controller
{
    public function index()
    {
        $banners = Banner::all();
        return view('backend.modules.banners.index', compact('banners'));
    }

    public function create()
    {
        return view('backend.modules.banners.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,jpg,png,gif,svg|max:5048',
        ]);

        $file = $request->image;
        $file_name = time() . '.' . $file->getClientOriginalExtension();
        $destination = public_path() . '/banners';
        $file->move($destination, $file_name);

        $banners = Banner::create([
            'image' => $file_name,
        ]);

        return redirect('admin/banners')->with('success', 'Successfully added new banner.');
    }

    public function destroy($id)
    {
        $banners = Banner::findOrFail($id);
        $banners->delete();

        return redirect('admin/banners')->with('success', 'Successfully deleted banner.');
    }
}
