<?php

namespace App\Http\Controllers\Backend;

use App\Models\Brand;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class BrandController extends Controller
{
    public function index()
    {
        $brands = Brand::all();

        return view('backend.modules.brands.index' , compact('brands'));
    }

    public function create()
    {
        return view('backend.modules.brands.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'logo' => 'required|image|mimes:jpeg,jpg,png,gif,svg|max:5048',
            'title' => 'required',
            'description' => 'required',
        ]);

        $file = $request->logo;
        $file_name = time() .'pi' . '.' . $file->getClientOriginalExtension();
        $destination = public_path() . '/uploads/brands';
        $file->move($destination, $file_name);

        Brand::create([
            'logo' => $file_name,
            'title' => $request->title,
            'description' => $request->description,
        ]);

        return redirect('admin/brands')->with('success', 'Brand added successfully');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $brands = Brand::findOrFail($id);
        return view('backend.modules.brands.edit', compact('brands'));
    }

    public function update(Request $request, $id)
    {
        $brands = Brand::findorFail($id);

        if($request->logo != null){
            $request->validate([
                'logo' => 'required|image|mimes:jpeg,jpg,png,gif,svg|max:5048',
                'title' => 'required',
                'description' => 'required',
            ]);

            $file = $request->logo;
            $file_name = time() .'pi' . '.' . $file->getClientOriginalExtension();
        $destination = public_path() . '/uploads/brands';
            $file->move($destination, $file_name);
    
            $brands->update([
                'logo' => $file_name,
                'title' => $request->title,
                'description' => $request->description,
            ]);
        } else{
            $brands->update([
                'title' => $request->title,
                'description' => $request->description,
            ]);
        }

        return redirect('admin/brands')->with('success', 'Successfully edited brand.');
    }

    public function destroy($id)
    {
        $brands = Brand::findOrFail($id);
        $brands->delete();

        return redirect('admin/brands')->with('success', 'Successfully deleted brand');
    }
}
