<?php

namespace App\Http\Controllers\Backend;

use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CategoryController extends Controller
{
    public function index()
    {
        $categories = Category::all();
        return view('backend.modules.categories.index' , compact('categories'));
    }

    public function create()
    {
        return view('backend.modules.categories.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:categories,name',
        ]);
    
        $categories = Category::create([
            'name' => $request->name,
        ]);

        return redirect('admin/categories')->with('success', 'Successfully added new category.');
    }


    public function destroy($id)
    {
        $categories = Category::findOrFail($id);
        $categories->delete();

        return redirect('admin/categories')->with('success', 'Successfully deleted category.');
    }
}
