<?php

namespace App\Http\Controllers\Backend;

use App\Models\Order;
use App\Models\TrendSize;
use App\Models\TrendColor;
use App\Models\ProductSkin;
use App\Models\ProductTrend;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class OrderController extends Controller
{
    public function index()
    {
        $orders = Order::all();
        $orders->transform(function ($order) {
            $order->items = json_decode($order->item);
            return $order;
        });
    
        return view('backend.modules.orders.index', compact('orders'));
    }

    public function show($id)
    {
        $orders = Order::findOrFail($id);
        return view('backend.modules.orders.show', compact('orders'));
    }

    public function edit($id)
    {
        $orders = Order::findOrFail($id);
        $trends = ProductTrend::get();
        $skins = ProductSkin::get();
        $colors = TrendColor::get();
        $sizs = TrendSize::get();
        
        return view('backend.modules.orders.edit', compact('orders', 'trends', 'skins'));
    }
    
    public function update(Request $request, $id)
    {
        $orders = Order::findOrFail($id);
        $colors = TrendColor::get();
        $sizes = TrendSize::get();
        $trends = ProductTrend::get();
        $skins = ProductSkin::get();
        
        $items = json_decode($orders->item);
        $quantities = json_decode($orders->quantity);
        $orderColor = json_decode($orders->color);
        $orderSize = json_decode($orders->size);
        $orderId = json_decode($orders->color_id);
        
        // return $items;
        if ($request->order_status == 'Completed Orders') {
            foreach ($items as $key => $item) {
                if ($item->type == 'trends') {
                    $size = $sizes->where('trend_color_id', $item->id)
                    ->where('size', $item->attributes->size)->first();
                    $size->stocks = $size->stocks - $item->qty;
                    $size->save();
                }
                if ($item->type == 'skins') {
                    $skin = $skins->where('name', $item->name)->first();
                    $skin->stocks = $skin->stocks - $item->qty;
                    $skin->save();
                }
            }

        }
        
        $orders->update($request->all());

        return back()->with('success', 'Successfully updated order');
    }
    
    public function destroy($id)
    {
        $orders = Order::findOrFail($id);
        $orders->delete();

        return back()->with('success', 'Order Deleted Successfully');
    }
}
