<?php

namespace App\Http\Controllers\Backend;

use App\Models\ProductSkin;
use Illuminate\Http\Request;
use App\Http\Traits\FileUpload;
use App\Http\Controllers\Controller;

class ProductSkinController extends Controller
{
    use FileUpload;

    public function index()
    {
        $skins = ProductSkin::get();
        return view('backend.modules.skins.index', compact('skins'));
    }

    public function create()
    {
        return view('backend.modules.skins.create');
    }

    public function store(Request $request)
    {
        if(isset($request->multiple_images)) {
            foreach ($request->multiple_images as $key => $value) {
                if($value->getError() === UPLOAD_ERR_OK) { // Check for upload error
                    $arrayImages[] = $this->fileUpload($value);
                }
            }
        } else {
            $arrayImages = []; // Handle null case
        }
        
        $request->validate([
            'thumbnail' => 'required|required|mimes:jpeg,jpg,png',
            'name' => 'required|string',
            'price' => 'required|numeric',
            'stocks' => 'required|numeric',
        ]);
        
        $file = $request->thumbnail;
        $file_name = time() .'pi' . '.' . $file->getClientOriginalExtension();
        $destination = public_path() . '/uploads/skins';
        $file->move($destination, $file_name);
        
        ProductSkin::create([
            'thumbnail' => $file_name,
            'multiple_images' => json_encode($arrayImages),
            'name' => $request->name,
            'price' => $request->price,
            'stocks' => $request->stocks,
            'description' => $request->description,
            'ingredients' => $request->ingredients,
            'reviews' => $request->reviews,
        ]);

        return redirect('admin/skins')->with('success', 'product added Successfully');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $skins = ProductSkin::findOrFail($id);
        return view('backend.modules.skins.edit', compact('skins'));
    }

    public function update(Request $request, $id)
    {
        $skins = ProductSkin::findOrFail($id);

        if($request->thumbnail != null){

            $request->validate([
                'thumbnail' => 'required|required|mimes:jpeg,jpg,png',
            ]);

            $file = $request->thumbnail_image;
            $file_name = time() .'pi' . '.' . $file->getClientOriginalExtension();
            $destination = public_path() . '/uploads/skins';
            $file->move($destination, $file_name);

            $skins->update([
                'thumbnail' => $file_name,
                'name' => $request->name,
                'price' => $request->price,
                'stocks' => $request->stocks,
                'description' => $request->description,
                'ingredients' => $request->ingredients,
                'reviews' => $request->reviews,
            ]);

        } elseif($request->thumbnail != null && $request->multiple_images != null){
            
            if(isset($request->multiple_images)) {
                foreach ($request->multiple_images as $key => $value) {
                    if($value->getError() === UPLOAD_ERR_OK) { // Check for upload error
                        $arrayImages[] = $this->fileUpload($value);
                    }
                }
            } else {
                $arrayImages = []; // Handle null case
            }

            $file = $request->thumbnail_image;
            $file_name = time() .'pi' . '.' . $file->getClientOriginalExtension();
            $destination = public_path() . '/uploads/skins';
            $file->move($destination, $file_name);

            $request->validate([
                'thumbnail' => 'required|required|mimes:jpeg,jpg,png',
                'name' => 'required|string',
                'price' => 'required|numeric',
                'stocks' => 'required|numeric',
            ]);

            $skins->update([
                'thumbnail' => $file_name,
                'multiple_images' => json_encode($arrayImages),
                'name' => $request->name,
                'price' => $request->price,
                'stocks' => $request->stocks,
                'description' => $request->description,
                'ingredients' => $request->ingredients,
                'reviews' => $request->reviews,
            ]);

        } elseif($request->multiple_images != null){

            if(isset($request->multiple_images)) {
                foreach ($request->multiple_images as $key => $value) {
                    if($value->getError() === UPLOAD_ERR_OK) { // Check for upload error
                        $arrayImages[] = $this->fileUpload($value);
                    }
                }
            } else {
                $arrayImages = []; // Handle null case
            }

            $request->validate([
                'name' => 'required|string',
                'price' => 'required|numeric',
                'stocks' => 'required|numeric',
            ]);

            $skins->update([
                'multiple_images' => json_encode($arrayImages),
                'name' => $request->name,
                'price' => $request->price,
                'stocks' => $request->stocks,
                'description' => $request->description,
                'ingredients' => $request->ingredients,
                'reviews' => $request->reviews,
            ]);

        } else {

            $request->validate([
                'name' => 'required|string',
                'price' => 'required|numeric',
                'stocks' => 'required|numeric',
            ]);

            $skins->update([
                'name' => $request->name,
                'price' => $request->price,
                'stocks' => $request->stocks,
                'description' => $request->description,
                'ingredients' => $request->ingredients,
                'reviews' => $request->reviews,
            ]);
        }

        return back()->with('success', 'Successfully edited product.');
    }

    public function destroy($id)
    {
        $skins = ProductSkin::findOrFail($id);
        $skins->delete();

        return redirect('admin/skins')->with('success', 'Product deleted successfully');
    }
}
