<?php

namespace App\Http\Controllers\Backend;

use App\Models\Category;
use App\Models\ProductType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TypeController extends Controller
{
    public function index()
    {
        $types = ProductType::all();
        return view('backend.modules.types.index' , compact('types'));
    }

    public function create()
    {
        return view('backend.modules.types.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|unique:product_types,type',
        ]);
    
        $types = ProductType::create([
            'type' => $request->type,
        ]);

        return redirect('admin/types')->with('success', 'Successfully added new type.');
    }


    public function destroy($id)
    {
        $types = ProductType::findOrFail($id);
        $types->delete();

        return redirect('admin/types')->with('success', 'Successfully deleted type.');
    }
}
