<?php

namespace App\Http\Controllers\Backend;

use App\Models\ProductSkin;
use App\Models\VoucherSkin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class VoucherSkinController extends Controller
{
    public function index()
    {
        $voucher_skins = VoucherSkin::latest()->get();
        return view('backend.modules.voucher-skins.index', compact('voucher_skins'));
    }

    public function create()
    {
        $skins = ProductSkin::orderBy('name', 'ASC')->get();
        return view('backend.modules.voucher-skins.create', compact('skins'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'code' => 'required|unique:voucher_skins,code',
            'amount' => 'required|numeric',
            'type' => 'required',
        ]);

        VoucherSkin::create([
            'code' => $request->code,
            'type' => $request->type,
            'amount' => $request->amount,
            'count_app' => $request->count_app,
            'product_promo' => json_encode($request->product_promo),
        ]);

        return redirect('admin/voucher-skins')->with('success', 'New voucher code added successfully');
    }

    public function show(Request $request, $id)
    {
        $voucher_skins = VoucherSkin::findOrFail($id);
        return view('backend.modules.voucher-skins.show', compact('voucher_skins'));
    }

    public function edit($id)
    {
        $voucher_skins = VoucherSkin::findOrFail($id);
        $skins = ProductSkin::orderBy('name', 'ASC')->get();
        return view('backend.modules.voucher-skins.edit', compact('voucher_skins', 'skins'));
    }

    public function update(Request $request, $id)
    {
        $voucher_skins = VoucherSkin::findOrFail($id);

        $request->validate([
            'code' => 'required|unique:voucher_skins,code,' . $id,
            'amount' => 'required|numeric',
            'type' => 'required',
        ]);

        $voucher_skins->update([
            'code' => $request->code,
            'type' => $request->type,
            'amount' => $request->amount,
            'count_app' => $request->count_app,
            'product_promo' => json_encode($request->product_promo),
        ]);

        return redirect('admin/voucher-skins')->with('success', 'New voucher code edited successfully');
    }

    public function destroy($id)
    {
        $voucher_skins = VoucherSkin::findOrFail($id);
        $voucher_skins->delete();
        return back()->with('success', 'Voucher code deleted successfully');
    }
}
