<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_skins', function (Blueprint $table) {
            $table->id();
            $table->longText('thumbnail');
            $table->longText('multiple_images')->nullable();
            $table->longText('name');
            $table->integer('price');
            $table->integer('stocks');
            $table->longText('description')->nullable();
            $table->longText('ingredients')->nullable();
            $table->longText('reviews')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_skins');
    }
};
