<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_trends', function (Blueprint $table) {
            $table->id();
            $table->longText('thumbnail');
            $table->longText('multiple_images')->nullable();
            $table->longText('name');
            $table->integer('price');
            $table->integer('stocks');
            $table->longText('category');
            $table->longText('type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_trends');
    }
};
