
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>eg Apparel | CMS</title>
  <meta name="csrf-token" content="{{ csrf_token() }}" />

  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.css" />
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  @yield('css')
  <link rel="stylesheet" href="{{ asset('css/admin.css') }}">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
            @yield('navbar')
        </ul>
        <ul class="navbar-nav ml-auto">
            <li class="nav-item">
            <form action="{{ url('admin/logout') }}" method="POST">@csrf
                <button class="btn btn-dark">
                    <i class="fas fa-power-off"></i>
                </button>
            </form>
            </li>
        </ul>
    </nav>
  <!-- /.navbar -->

    <!-- Main Sidebar Container -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <!-- Brand Logo -->
        <a href="{{ url('admin/dashboard') }}" class="brand-link">
            CMS
            <span class="brand-text font-weight-light">| eg Apparel</span>
        </a>

        <!-- Sidebar -->
        <div class="sidebar">
            <!-- Sidebar Menu -->
            <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-item">
                    <a href="{{ url('admin/dashboard') }}" class="nav-link">
                        <i class="nav-icon fas fa-home"></i>
                        <p>
                            Dashboard
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ url('admin/banners') }}" class="nav-link">
                        <i class="fa-solid fa-images"></i>
                        <p>Banners</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ url('admin/brands') }}" class="nav-link">
                        <i class="fa-solid fa-b"></i>
                        <p>Brands</p>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="fa-solid fa-filter"></i>
                        <p>
                            Product Categories
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview" style="display: none;">
                        <li class="nav-item">
                            <a href="{{ url('admin/categories') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Main Category</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('admin/types') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Type</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ url('admin/sub-types') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Sub Type</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="fa-solid fa-shop"></i>
                        <p>
                            Product Management
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview" style="display: none;">
                        <li class="nav-item">
                            <a href="{{ url('admin/skins') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Skin Essentials</p>
                            </a>
                        </li>
        
                        <li class="nav-item">
                            <a href="{{ url('admin/trends') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Trends Apparel</p>
                            </a>
                        </li>

                        {{-- <li class="nav-item">
                            <a href="{{ url('admin/add-colors') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Trends Apparel Color Management</p>
                            </a>
                        </li> --}}
                    </ul> 
                </li>

                <li class="nav-item">
                    <a href="{{ url('admin/orders') }}" class="nav-link">
                        <i class="fa-solid fa-inbox"></i>
                        <p>Order Management</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ url('admin/careers') }}" class="nav-link">
                        <i class="fa-solid fa-briefcase"></i>
                        <p>Careers</p>
                    </a>                    
                </li>

                <li class="nav-item">
                    <a href="{{ url('admin/blogs/') }}" class="nav-link">
                        <i class="fa-solid fa-newspaper"></i>
                        <p>Blog</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="{{ url('admin/inquiries/') }}" class="nav-link">
                        <i class="fa-solid fa-inbox"></i>
                        <p>Inquiry</p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="fa-solid fa-tags"></i>
                        <p>
                            <p>Promo</p>
                            <i class="fas fa-angle-left right"></i>
                        </p>
                    </a>

                    <ul class="nav nav-treeview" style="display: none;">
                        <li class="nav-item">
                            <a href="{{ url('admin/voucher-skins') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Skin Essentials</p>
                            </a>
                        </li>
        
                        <li class="nav-item">
                            <a href="{{ url('admin/voucher-trends') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Trends Apparel</p>
                            </a>
                        </li>
                    </ul> 
                </li>

            </ul>

        </nav>
        <!-- /.sidebar-menu -->
        </div>
        <!-- /.sidebar -->
    </aside>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        @if (Session::has('success'))
        <div class="alert alert-success alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-check"></i> Success!</h5>
            {{ Session::get('success') }}
          </div>
        @endif
        @if (Session::has('error'))
        <div class="alert alert-error alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
            <h5><i class="icon fas fa-check"></i> Error!</h5>
            {{ Session::get('error') }}
          </div>
        @endif
        @yield('content')
    </div>
  <!-- /.content-wrapper -->


</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<script src="{{ asset('js/admin.js') }}"></script>
@yield('js')

</body>
</html>
