@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="row">
        <div class="col-12 col-md-8">
            <h5 class="fw-bold">Item: {{ $trends->name }}</h5>
            <form method="POST" action="{{ url('admin/add-colors?product_id=' . $trends->id) }}" enctype="multipart/form-data">@csrf
                <div class="card">
                    <div class="card-header fw-bold">
                        Add Color
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 form-group">
                                <label>Name:</label>
                                <input class="form-control" type="text" name="name" value="{{ old('name') }}">
                                @error('name')
                                    <code>{{ $message }}</code>
                                @enderror
                            </div>
                            <div class="col-12 form-group">
                                <label>Item Images</label>
                                <input type="file" class="form-control" name="multiple_images[]" value="{{ old('multiple_images[]') }}" multiple/>
                            </div>
                            <div class="col-12 form-group">
                                <label>Stocks</label>
                                <input class="form-control" type="text" name="color_stocks" value="{{ old('color_stocks') }}">
                                @error('color_stocks')
                                    <code>{{ $message }}</code>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button type="submit" class="btn btn-success">Add Color</button>
                    </div>
            </div>
            </form>
        </div>
        <div class="col-12 col-md-4">
            <form class="mb-3" method="POST" action="{{ url('admin/add-sizes?product_id=' . $trends->id) }}" enctype="multipart/form-data">@csrf
                <div class="card">
                    <div class="card-header">
                        <h5>Sizes:</h5>
                    </div>
                    <div class="card-body p-2">
                        <div class="row">
                            <div class="col-12 form-group">
                                <label>Size:</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="name" id="size_xs" value="Extra Small" {{ old('name') === 'Extra Small' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_xs">
                                        Extra Small
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="name" id="size_s" value="Small" {{ old('name') === 'Small' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_s">
                                        Small
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="name" id="size_m" value="Medium" {{ old('name') === 'Medium' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_m">
                                        Medium
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="name" id="size_l" value="Large" {{ old('name') === 'Large' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_l">
                                        Large
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="name" id="size_xl" value="Extra Large" {{ old('name') === 'Extra Large' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_xl">
                                        Extra Large
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="name" id="size_freesize" value="Freesize" {{ old('name') === 'Freesize' ? 'checked' : '' }}>
                                    <label class="form-check-label" for="size_freesize">
                                        Freesize
                                    </label>
                                </div>
                                @error('name')
                                    <code>{{ $message }}</code>
                                @enderror
                            </div>
                            
                            <div class="col-12 form-group">
                                <label>Stocks</label>
                                <input class="form-control" type="text" name="size_stocks" value="{{ old('size_stocks') }}">
                                @error('size_stocks')
                                    <code>{{ $message }}</code>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button type="submit" class="btn btn-success">Add Size</button>
                    </div>
                </div>
            </form>

            <div class="card">
                <div class="card-header">
                    Sizes:
                </div>
                <div class="card-body">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Size</th>
                                <th>Stocks</th>
                                <th class="text-right"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($colors->sizes as $size)
                            <tr>
                                <td>{{ $size->name }}</td>
                                <td>{{ $size->size_stocks }}</td>
                                <td class="text-right">
                                    <form action="{{ url('admin/add-sizes/' . $size->id) }}" method="POST">
                                        @csrf
                                        @method('delete')
                                        <button type="submit" class="btn btn-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                        
                    </table>
                </div>
            </div>


        </div>
    </div>
</div>

@section('css')
@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>
<script type="text/javascript">
    CKEDITOR.replace('materials');
</script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
@endsection

@endsection