@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Edit Blog
        </div>
    </div>
    <form action="{{ url('admin/blogs/' . $blogs->id) }}" method="POST" enctype="multipart/form-data">@csrf @method('put')
    <div class="row">
        <div class="col-12 col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="row">
    
                        <div class="col-12 mb-3">
                            <label for="">Thumbnail Image </label>
                            <input type="file" class="form-control" name="thumbnail" value="{{ $blogs->thumbnail }}" />
                            @error('thumbnail')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
    
                        <div class="col-12 mb-3">
                            <label for="">Multiple Images</label> <span><i>(Please add thumbnail image here)</i></span>
                            <input type="file" class="form-control" name="multiple_images[]" value="{{ $blogs->multiple_images }}" multiple/>
                        </div>
    
                        <div class="col-12 mb-3">
                            <label for="">Embed Youtube Link </label><span><i>(Optional)</i></span>
                            <input type="text" class="form-control" name="youtube_link" value="{{ $blogs->youtube_link }}" />
                        </div>
    
                        <div class="col-12 mb-3">
                            <label for="">Title </label>
                            <input type="text" class="form-control" required name="title" value="{{ $blogs->title }}" />
                            @error('title')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
    
                        <div class="col-12 mb-3">
                            <label for="">Author Name </label>
                            <input type="text" class="form-control" required name="author" value="{{ $blogs->author }}" />
                            @error('author')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
    
                        <div class="col-12 mb-3">
                            <label for="">Description </label>
                            <textarea type="textarea" rows="3" class="form-control" id="description" required name="description">{!! $blogs->description !!}</textarea>
                            @error('description')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
    
                        <div class="col-12 text-right">
                            <button type="submit" class="btn btn-success">Edit News</button>
                        </div>
                    </div>
            </div>
            </div>
        </div>
    </form>
        <div class="col-12 col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Current Thumbnail:</h5>
                </div>
                <div class="card-body p-2">
                    <img src="{{ asset('uploads/blogs/'.$blogs->thumbnail) }}" alt="Current thumnbnail image" style="max-height: 200px">
                </div>
            </div>
            <div class="card">
                <div class="card-header">
                    <h5>Current Multiple Images:</h5>
                </div>
                <div class="card-body p-2">
                    @php
                    $images = json_decode($blogs->multiple_images) ?? [];
                  @endphp
                  @foreach ($images as $key => $multiple_images)
                  <img src="{{ asset('uploads/' . $multiple_images) }}" style="max-width: 100px" alt="">
                  @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>

<script>
$('.dropdown-toggle').dropdown();
</script>
@endsection