@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Edit Brand
        </div>
    </div>
    <form action="{{ url('admin/brands/' . $brands->id) }}" method="POST" enctype="multipart/form-data">@csrf @method('put')
    <div class="row">
        <div class="col-12 col-md-8">
            <div class="card">
                <div class="card-body">
                    <div class="row">
    
                        <div class="col-12 mb-3">
                            <label for="">Logo </label>
                            <input type="file" class="form-control" name="logo" value="{{ $brands->logo }}" />
                            @error('logo')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
    
                        <div class="col-12 mb-3">
                            <label for="">Title </label>
                            <input type="text" class="form-control" required name="title" value="{{ $brands->title }}" />
                            @error('title')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
    
                        <div class="col-12 mb-3">
                            <label for="">Description </label>
                            <textarea type="textarea" rows="3" class="form-control" id="description" required name="description">{!! $brands->description !!}</textarea>
                            @error('description')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                            @enderror
                        </div>
    
                        <div class="col-12 text-right">
                            <button type="submit" class="btn btn-success">Edit Brand</button>
                        </div>
                    </div>
            </div>
            </div>
        </div>
    </form>
        <div class="col-12 col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>Current Logo:</h5>
                </div>
                <div class="card-body p-2">
                    <img src="{{ asset('uploads/brands/'.$brands->logo) }}" alt="Current thumnbnail image" style="max-height: 200px">
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>

<script>
$('.dropdown-toggle').dropdown();
</script>
@endsection