@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Edit Career
        </div>
        <div class="card-body">
            <form action="{{ url('admin/careers/'. $careers->id) }}" method="POST" enctype="multipart/form-data">@csrf @method('put')
                <div class="row">

                    <div class="col-12 mb-3">
                        <label for="">Position </label>
                        <input type="text" class="form-control" name="title" value="{{ $careers->title }}" />
                        @error('title')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Vacancy </label>
                        <input type="number" class="form-control" required name="vacancy" value="{{ $careers->vacancy }}" />
                        @error('vacancy')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="">Office Location </label>
                        <input type="text" class="form-control" required name="location" value="{{ $careers->location }}" />
                        @error('location')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                  </div>

                    <div class="col-12 mb-3">
                        <label for="">Description </label>
                        <textarea type="text" class="form-control" rows="3" required id="description" name="description">{!! $careers->description !!}</textarea>
                        @error('description')
                            <span class="text-danger">
                                {{ $message }}
                            </span>
                        @enderror
                    </div>
                    
                    <div class="col-12 text-right">
                        <button type="submit" class="btn btn-success">Update Career</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>
<script>
$('.dropdown-toggle').dropdown();
</script>
@endsection