@extends('backend.layouts.app')

@section('content')

<div class="p-3">
  <div class="card">
      <div class="card-header fw-bold">
        <span class="fw-bold">Careers</span>&emsp;
        <a href="{{ url('admin/careers/create') }}" class="text-decoration-none">
          <button type="button" class="btn btn-success">
            <i class="fas fa-edit nav-icon"></i>
            Add Career
          </button>
        </a>
      </div>
      <div class="card-body">
          <table class="table table-striped" style="width:100%">
              <thead>
                <tr>
                  <th>Position</th>
                  <th>Vacancy</th>
                  <th>Location</th>
                  <th>Description</th>
                  <th>Action</th>
                </tr>
              </thead>
              
              <tbody>
                @foreach ($careers as $items)
                  <tr>
                      <td>{{ $items->title }}</td>
                      <td>{{ $items->vacancy }}</td>
                      <td>{{ $items->location }}</td>
                      <td>{!! $items->description !!}</td>
                      <td>
                        <div class="d-flex">
                          <a href="{{ url('admin/careers/' .$items->id) }}/edit">
                            <button type="button" class="btn btn-outline-primary">Edit</button>
                          </a>
                          <form action="{{ url('admin/careers/' .$items->id) }}/edit" 
                            method="POST" class="mx-3"> @csrf @method('delete')
                            <button class="btn btn-danger" type="submit">Delete</button>
                          </form>
                        </div>
                      </td>
                  </tr>
                @endforeach
              </tbody>
              
            </table>
      </div>
  </div>
</div>

@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready( function () {
    $('.table').DataTable();
} );
</script>
@endsection