@extends('backend.layouts.app')

@section('content')
<div class="p-2">
  <div class="row mb-5">

    <div class="col-lg-3 col-6">
      <div class="small-box bg-success">
        <div class="inner">
          <h3>{{ count(App\Models\Order::where('order_status', 'Completed Orders')->get()) }}</h3>
          <p>Completed Orders</p>
        </div>
        <div class="icon">
          <i class="ion ion-person-add"></i>
        </div>
        <a href="{{ url('admin/orders?order_status=Completed Orders') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
      </div>
    </div>

    <div class="col-lg-3 col-6">
      <div class="small-box bg-primary">
        <div class="inner">
          <h3>{{ count(App\Models\Order::where('order_status', 'For Confirmation')->get()) }}</h3>
          <p>For Confirmation</p>
        </div>
        <div class="icon">
          <i class="ion ion-person-add"></i>
        </div>
        <a href="{{ url('admin/orders?order_status=For Confirmation') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
      </div>
    </div>

    <div class="col-lg-3 col-6">
      <div class="small-box bg-danger">
        <div class="inner">
          <h3>{{ count(App\Models\Order::where('order_status', 'Failed Orders')->get()) }}</h3>
          <p>Failed Orders</p>
        </div>
        <div class="icon">
          <i class="ion ion-person-add"></i>
        </div>
        <a href="{{ url('admin/orders?order_status=Failed Orders') }}" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
      </div>
    </div>

  </div>

  <div class="card mb-3">
    {{-- <div class="card-header fw-bold">
      <span class="fw-bold">eg Skin Apparel</span>&emsp;
    </div>
    <div class="card-body">
        <table class="table table-striped" style="width:100%">
            <thead>
              <tr>
                <th style="width: 10%">ID</th>
                <th>Product Name</th>
                <th>Stocks</th>
              </tr>
            </thead>
            
            <tbody>
              @foreach ($skins as $items)
              <tr>
                  <td>{{$items->id}}</td>
                  <td>{{$items->name}}</td>
                  <td>{{$items->stocks}}</td>
              </tr>
            @endforeach
            </tbody>
          </table>
    </div>
</div>

  <div class="card mb-3">
    <div class="card-header fw-bold">
      <span class="fw-bold">eg Trend Essentials</span>&emsp;
    </div>
    <div class="card-body">
        <table class="table table-striped" style="width:100%">
            <thead>
              <tr>
                <th style="width: 10%">ID</th>
                <th>Product Name</th>
                <th>Color</th>
                <th>Stocks</th>
              </tr>
            </thead>
            
            <tbody>
              @foreach ($colors as $items)
              <tr>
                <td>{{$items->id}}</td>
                <td>{{$items->name}}</td>
                <td>{{$items->color}}</td>
                <td>{{$items->color_stocks}}</td>
              </tr>
            @endforeach
            </tbody>
          </table>
    </div>
</div> --}}
</div>
@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready( function () {
    $('.table').DataTable();
} );
</script>
@endsection