@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            <h5>Edit Order</h5>
        </div>
        <div class="card-body">
          <form action="{{ url('admin/orders/' . $orders->id) }}" method="POST" enctype="multipart/form-data">@csrf @method('put')
              <div class="row">
                <div class="col-12 mb-3">
                  <label for="">Edit Order Status</label><br>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="order_status" id="order_status_1" value="Failed Orders" @if ($orders->order_status == 'Failed Orders') checked @endif>
                    <label class="form-check-label" for="order_status_1">
                      Failed Orders
                    </label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="order_status" id="order_status_2" value="For Confirmation" @if ($orders->order_status == 'For Confirmation') checked @endif>
                    <label class="form-check-label" for="order_status_2">
                      For Confirmation
                    </label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="order_status" id="order_status_3" value="Completed Orders" @if ($orders->order_status == 'Completed Orders') checked @endif>
                    <label class="form-check-label" for="order_status_3">
                      Completed Orders
                    </label>
                  </div>
                  @error('order_status')
                    <span class="text-danger">{{ $message }}</span>
                  @enderror
                </div>
                <div class="col-12 mb-3">
                  <label for="">Edit Order Status</label><br>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="service_type" id="service_type_1" value="Pick up" @if ($orders->service_type == 'Pick up') checked @endif>
                    <label class="form-check-label" for="service_type_1">
                      For Pick up
                    </label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="service_type" id="service_type_2" value="Delivery" @if ($orders->service_type == 'Delivery') checked @endif>
                    <label class="form-check-label" for="service_type_2">
                      For Delivery
                    </label>
                  </div>
                </div>

                  <div class="col-12 text-right">
                      <button type="submit" class="btn btn-success">Update Order</button>
                  </div>
              </div>
          </form>
        </div>
    </div>
</div>

@section('css')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script>
    $(function () {
        bsCustomFileInput.init();

        $('#description').summernote()
    });
</script>
@endsection

@endsection