@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
          <span class="fw-bold">Inquiries</span>&emsp;
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th style="width: 10%">ID</th>
                    <th style="width: 10%">Reference #</th>
                    <th>Customer Info</th>
                    <th>Items</th>
                    <th>Total Amount</th>
                    <th>Order Status</th>
                    <th>Date & Time to Pick up / Deliver</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                  @foreach ($orders as $order)
                  <tr>
                      <td>{{ $order->id }}</td>
                      <td>{{ $order->reference }}</td>
                      <td>
                        {{ $order->first_name }} {{ $order->last_name }} <br>
                        {{ $order->phone }} <br>
                      </td>
                      <td>
                        @foreach ($order->items as $item)
                          @if ($item->type == 'trends')
                            @if (isset($item->attributes) && isset($item->attributes->color) && isset($item->attributes->size))
                              {{ $item->qty }} x {{ $item->name }} (Color: {{ $item->attributes->color }}, Size: {{ $item->attributes->size }}) <br>
                            @endif
                          @else
                            {{ $item->qty }} x {{ $item->name }} (Skincare) <br>
                          @endif
                        @endforeach
                      </td>
                      <td>P {{ number_format($order->total, 2) }}</td>
                      <td>{{ $order->order_status }}</td>
                      <td>
                        {{ date('F d, Y', strtotime($order->assigned_date)) }} at {{ date('h:i A', strtotime($order->assigned_time)) }}
                      </td>
                      <td>
                        <div>
                          <button type="button" class="btn btn-success btn-block mb-1" data-toggle="modal" data-target="#exampleModal{{ $order->id }}"> View </button>
                          @if ($order->payment_status == 'Unpaid')
                          <form action="{{ url('admin/orders/' . $order->id) }}" method="POST" class="d-inline">
                              <input type="hidden" value="Paid" name="payment_status" />
                              @csrf @method('PUT')
                              <button type="submit" class="btn btn-primary btn-block mb-1">
                                  Paid
                              </button>
                          </form>
                          @endif
                          <a href="{{ url('admin/orders/' . $order->id) }}/edit">
                              <button type="button" class="btn btn-outline-primary btn-block mb-1"> Edit </button>
                          </a>
                          <form action="{{ url('admin/orders/' . $order->id ) }}" method="POST"> @csrf @method('delete')
                            <button class="btn btn-danger btn-block" type="submit">Delete</button>
                          </form>

                          <div class="modal fade" id="exampleModal{{$order->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                              <div class="modal-content">
            
                                <div class="modal-body">
                                  <div  class="modal-title" id="exampleModalLabel">
            
                                    <div class="mb-2">
                                        <span class="font-weight-bold">Order No</span><br>
                                        <span>#{{ $order->reference }}</span><br>
                                    </div>
        
                                    <div class="mb-2">
                                        <span class="font-weight-bold">Customer Info</span><br>
                                        <span>Customer Name:&nbsp; {{ $order->first_name }} {{ $order->last_name }}</span><br>
                                        <span>Address:&nbsp; {{ $order->address }}</span><br>
                                        <span>Email:&nbsp; {{ $order->email }}</span><br>
                                        <span>Contact No:&nbsp; {{ $order->phone }}</span>
                                    </div>
        
                                    <div class="mb-2">
                                        <span class="font-weight-bold">Customer Order Info</span><br>
                                        @php
                                        $items = json_decode($order->item);
                                        $quantities = json_decode($order->quantity);
                                        @endphp
                                        @if ($items && $quantities)
                                          @foreach ($items as $index => $item)
                                            {{ $quantities[$index] }} x {{ $item }}<br>
                                          @endforeach
                                        @endif
                                        <span>Date of Order:&nbsp; {{ date('F d, Y', strtotime($order->created_at)) }}</span><br>
                                        <span>Payment Method:&nbsp; <span class="text-uppercase"><b>{{ $order->payment_method }}</b></span></span><br>
                                        <span>Payment Status:&nbsp; {{ $order->payment_status }}</span><br>
                                        <span>Service Type: &nbsp; {{ $order->service_type }}</span><br>
                                        <span>{{ $order->service_type }} Date: &nbsp; {{ date('F d, Y', strtotime($order->assigned_date)) }}</span><br>
                                        <span>{{ $order->service_type }} Time: &nbsp; {{ date('h:i A', strtotime($order->assigned_time)) }}</span><br>
                                        <span>Customer Note: &nbsp; {{ $order->notes }}</span>
                                    </div>
            
                                  </div>
                                </div>
            
                                <div class="modal-footer">
                                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
            
                              </div>
                            </div>
                          </div>
                        </div>
                      </td>
                  </tr>
                @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>


@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready(function () {
    $('.table').DataTable({
      "order": [[0, "desc"]]
    });
  });
</script>
@endsection