@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            Edit Product
        </div>
    </div>
    <form action="{{ url('admin/skins/' . $skins->id) }}" method="POST" enctype="multipart/form-data">@csrf @method('put')
        <div class="row">
            <div class="col-12 col-md-8">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label for="">Product Name </label>
                                <input type="text" class="form-control" required name="name" value="{{ $skins->name }}" />
                                @error('name')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
            
                            <div class="col-12 mb-3">
                                <label for="">Product Thumbnail Image </label>
                                <input type="file" class="form-control" name="thumbnail" value="{{ $skins->thumbnail }}" />
                                @error('thumbnail')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
            
                            <div class="col-12 mb-3">
                                <label for="">Product Images </label> <span><i>(Please add thumbnail image here)</i></span>
                                <input type="file" class="form-control" name="multiple_images[]" value="{{ $skins->multiple_images }}" multiple/>
                            </div>
            
                            <div class="col-12 mb-3">
                                <label for="">Price </label>
                                <input type="number" class="form-control" required name="price" value="{{ $skins->price }}" />
                                @error('price')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
            
                            <div class="col-12 mb-3">
                              <label for="">Stocks </label>
                              <input type="number" class="form-control" name="stocks" value="{{ $skins->stocks }}" />
                              @error('stocks')
                                  <span class="text-danger">
                                      {{ $message }}
                                  </span>
                              @enderror
                          </div>
            
                            <div class="col-12 mb-3">
                                <label for="">Description </label>
                                <textarea rows="3" type="text" class="form-control" id="description" name="description">{!! $skins->description !!}</textarea>
                            </div>

                            <div class="col-12 mb-3">
                              <label for="">Product Ingredients </label>
                              <textarea rows="3" type="text" class="form-control" name="ingredients" id="ingredients">{!! $skins->ingredients !!}</textarea>
                          </div>
            
                            <div class="col-12 text-right">
                                <button type="submit" class="btn btn-success">Edit Product</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
            <div class="col-12 col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5>Current Thumbnail:</h5>
                    </div>
                    <div class="card-body p-2">
                        <img src="{{ asset('uploads/skins/'.$skins->thumbnail) }}" alt="Current thumnbnail image" style="max-height: 200px">
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h5>Current Multiple Images:</h5>
                    </div>
                    <div class="card-body p-2">
                        @php
                        $images = json_decode($skins->multiple_images) ?? [];
                        @endphp
                        @foreach ($images as $key => $multiple_images)
                        <img src="{{ asset('uploads/' . $multiple_images) }}" style="max-width: 100px" alt="">
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
</div>

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
</script>
<script type="text/javascript">
    CKEDITOR.replace('ingredients');
</script>
@endsection

@endsection