@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header hstack">
            <span class="fw-bold">Skin Essentials Products</span>&emsp;
            <a href="{{ url('admin/skins/create') }}" class="text-decoration-none">
              <button type="button" class="btn btn-success">
                <i class="fas fa-edit nav-icon"></i>
                Add Product
              </button>
            </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Product Thumbnail</th>
                    <th>Product Name</th>
                    <th>Price</th>
                    <th>Stocks</th>
                    <th>Ingredients</th>
                    <th>Reviews</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    @foreach ($skins as $items)
                <tr>
                  <td>{{ $items->id }}</td>
                    <td>
                      <img src="{{ asset('uploads/skins/' . $items->thumbnail)}}" height="50" alt="">
                    </td>
                    <td>{{ $items->name}}</td>
                    <td>{{ $items->price, 2}}</td>
                    <td>{{ $items->stocks}}</td>
                    <td>{{ $items->ingredients}}</td>
                    <td>{{ $items->reviews }}</td>
                    <td class="d-flex">
                      <a href="
                      {{ url('admin/skins/' . $items->id) }}/edit" class="text-decoration-none">
                        <button type="button" class="btn btn-outline-primary">Edit</button>
                      </a>
                      <form action="{{ url('admin/skins/' . $items->id) }}" method="POST" class="mx-3"> @csrf @method('delete')
                        <button class="btn btn-danger" type="submit">Delete</button>
                      </form>
                    </td>
                </tr>
                @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
@yield('js')
<script>
    $(document).ready(function() {
        $('.table').DataTable({
        });
    });
</script>
@endsection