@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
            <div class="float-left">
                Edit Product
            </div>
            <div class="float-right">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-white mb-0 p-0">
                        <li class="breadcrumb-item"><a href="{{ url('admin/trends') }}">Trends Apparel</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Edit</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
        <div class="row">
            <div class="col-12 col-md-8">
                <form action="{{ url('admin/trends/' . $trends->id) }}" method="POST" enctype="multipart/form-data">@csrf @method('put')
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label for="">Product Name </label>
                                <input type="text" class="form-control" required name="name" value="{{ $trends->name }}" />
                                @error('name')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
            
                            <div class="col-12 mb-3">
                                <label for="">Product Thumbnail Image </label>
                                <input type="file" class="form-control" name="thumbnail" value="{{ $trends->thumbnail }}" />
                                @error('thumbnail')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label for="">Product Category </label>
                                <select class="form-select" aria-label="Default select example" name="category">
                                    <option selected disable hidden value="{{ $trends->category }}">{{ $trends->category }}</option>
                                    @foreach ($categories as  $items)
                                    <option value="{{ $items->name }}">{{ $items->name }}</option>
                                @endforeach
                                </select>
                                @error('category')
                                <span class="text-danger">
                                {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label for="">Product Type</label>
                                <select class="form-select" aria-label="Default select example" name="type" id="typeSelect">
                                <option selected disable hidden value="{{ $trends->type }}">{{ $trends->type }}</option>
                                    @foreach ($types as $item)
                                        <option value="{{ $item->type }}">{{ $item->type }}</option>
                                    @endforeach
                                </select>
                                @error('type')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label for="">Sub Type</label>
                                <select class="form-select" aria-label="Default select example" name="sub_type" id="typeSelect">
                                    <option selected disabled hidden value="{{ $trends->sub_type }}">{{ $trends->sub_type }}</option>
                                    @foreach ($sub as $item)
                                        <option value="{{ $item->sub_type }}">{{ $item->sub_type }}</option>
                                    @endforeach
                                </select>
                                @error('sub')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label for="">Price </label>
                                <input type="number" class="form-control" required name="price" value="{{ $trends->price }}" />
                                @error('price')
                                    <span class="text-danger">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>
            
                            <div class="col-12 mb-3">
                                <label for="">Description </label>
                                <textarea rows="3" type="text" class="form-control" id="description" name="description">{!! $trends->description !!}</textarea>
                            </div>

                            <div class="col-12 mb-3">
                                <label for="">Product Materials </label>
                                <textarea rows="3" type="text" class="form-control" name="materials" id="ingredients">{!! $trends->materials !!}</textarea>
                            </div>
            
                            <div class="col-12 text-right">
                                <button type="submit" class="btn btn-success">Edit Product</button>
                            </div>
                        </div>
                    </div>
                </div>
                </form>
            </div>
            <div class="col-12 col-md-4">
                <form class="card" method="POST" action="{{ url('admin/add-colors?product_trend_id=' . $trends->id) }}" enctype="multipart/form-data">@csrf
                <div class="card">
                    <div class="card-header">
                        Add Color
                    </div>
                    <div class="card-body p-2">
                        <div class="row">
                            <div class="col-12 form-group">
                                <label>Color:</label>
                                <input class="form-control" type="text" name="color" value="{{ old('color') }}">
                                @error('color')
                                    <code>{{ $message }}</code>
                                @enderror
                            </div>
                            <div class="col-12 form-group">
                                <label>Item Images</label>
                                <input type="file" class="form-control" name="color_images[]" value="{{ old('color_images[]') }}" multiple/>
                                @error('color_images')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-right">
                        <button type="submit" class="btn btn-success">Add Color</button>
                    </div>
                </div>
                </form>

                <div class="card mb-3">
                    <div class="card-header">
                        Variants:
                    </div>
                    <div class="card-body">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Color</th>
                                    <th style="width: 10%:">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($trends->colors as $items)
                                <tr>
                                    <td>{{ $items->color }}</td>
                                    <td class="d-flex">
                                        <a href="{{ url('admin/add-colors/' . $items->id) }}/edit" class="text-decoration-none btn btn-outline-primary">
                                            Edit
                                        </a>
                                        <form action="{{ url('admin/add-colors/' . $items->id) }}" class="mx-3" method="POST">
                                            @csrf @method('delete')
                                            <button type="submit" class="btn btn-danger">
                                                Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
</div>

@section('js')
<script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.replace('description');
    CKEDITOR.replace('materials');
</script>

<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
@yield('js')
<script>
    $(document).ready(function() {
        $('.table').DataTable({
            order: [['0', 'asc']]
        });
    });
</script>
@endsection

@endsection