@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header hstack">
            <span class="fw-bold">Trends Apparel Products</span>&emsp;
            <a href="{{ url('admin/trends/create') }}" class="text-decoration-none">
              <button type="button" class="btn btn-success">
                <i class="fas fa-edit nav-icon"></i>
                Add Product
              </button>
            </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Product Name</th>
                    <th>Thumbnail</th>
                    <th>Price</th>
                    <th>Main Category</th>
                    <th>Type</th>
                    <th>Sub Type</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    @foreach ($trends as $items)
                <tr>
                  <td>{{ $items->id }}</td>
                  <td>
                    <img src="{{ asset('uploads/trends/' . $items->thumbnail) }}" height="50" alt="">
                  </td>
                  <td>{{ $items->name }}</td>
                  <td>{{ $items->price, 2 }}</td>
                  <td>{{ $items->category }}</td>
                  <td>{{ $items->type }}</td>
                  <td>{{ $items->sub_type }}</td>
                  <td class="d-flex">
                    <a href="
                    {{ url('admin/trends/' . $items->id) }}/edit" class="text-decoration-none">
                      <button type="button" class="btn btn-outline-primary">Edit</button>
                    </a>
                    <form action="{{ url('admin/trends/' . $items->id) }}" class="mx-3" method="POST"> @csrf @method('delete')
                      <button class="btn btn-danger" type="submit">Delete</button>
                    </form>
                  </td>
                </tr>
                @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
@yield('js')
<script>
    $(document).ready(function() {
        $('.table').DataTable({
          order: [['0', 'desc']]
        });
    });
</script>
@endsection