@extends('backend.layouts.app')

@section('content')

<div class="p-3">
    <div class="card">
        <div class="card-header hstack">
            <span class="fw-bold">Skin Essentials Promo</span>&emsp;
            <a href="{{ url('admin/voucher-skins/create') }}" class="text-decoration-none">
              <button type="button" class="btn btn-success">
                <i class="fas fa-edit nav-icon"></i>
                Add Voucher
              </button>
            </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>Code</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Count Applicable</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    @foreach ($voucher_skins as $items)
                <tr>
                  <td>{{ $items->code }}</td>
                  <td>{{ $items->type }}</td>
                  <td>
                      @if($items->type === 'Fixed' || $items->type === 'Fixed count')
                      -{{ $items->amount }}
                      @else
                      {{ $items->amount }}%
                      @endif
                  </td>
                  <td>{{ $items->count_app }}</td>
                    <td class="d-flex">
                      <a href="
                      {{ url('admin/voucher-skins/' . $items->id) }}/edit" class="text-decoration-none">
                        <button type="button" class="btn btn-outline-primary">Edit</button>
                      </a>
                      <form action="{{ url('admin/voucher-skins/' . $items->id) }}" method="POST" class="mx-3"> @csrf @method('delete')
                        <button class="btn btn-danger" type="submit">Delete</button>
                      </form>
                    </td>
                </tr>
                @endforeach
                </tbody>
              </table>
        </div>
    </div>
</div>

@endsection

@section('js')
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
@yield('js')
<script>
    $(document).ready(function() {
        $('.table').DataTable({
        });
    });
</script>
@endsection