@extends('frontend.layouts.app')

@section('seo')
<title>Checkout | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Checkout | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Checkout | eg APPAREL" />
<meta property="og:image"           content="{{ asset('resources/web_thumb.jpg') }}" />
<meta property="og:thumbnail"       content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection


@section('content')

@php
$cart_total = 0;
@endphp
@if (session('cart'))
@foreach (session('cart') as $cart)
@php
    $cart_total += $cart['quantity'] * $cart['price'];
    $subtotal = 0;
    $discounted = 0;
    $countProductInPromo = 0;
@endphp
@endforeach
@endif

<div class="container py-5">
  <div class="text-center mb-5">
    <h1>Checkout</h1>
  </div>

  @if(session('success'))
  <div class="col-12">
      <div class="alert alert-success my-3">
          {{ session('success') }}
      </div>
  </div>
  @endif

  {{-- BILLING DETAILS --}}
  <form method="POST" action="{{ url('payment') }}">@csrf
  <input type="hidden" name="cart_total" value="{{ $cart_total }}" />
  <input type="hidden" name="total" value="{{ $cart_total }}" />
  <input type="hidden" name="service_type" value="{{ $service_type }}" />

  <section>
    <div class="mb-5">
      <span class="fs-5 fw-bold">BILLING DETAILS</span>
    </div>
    
    <div class="row gx-5 gy-3 mb-5">
      <div class="col-12 col-sm-12 col-md-12 col-lg-6">

        <div class="mb-3">
          <div class="row">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">First Name*</label>
              <input type="text" required value="{{ old('first_name') }}" name="first_name" class="form-control rounded-0 form-black" id="exampleFormControlInput1">

              @error('first_name')
              <span class="text-danger">
                <code>{{ $message }}</code>
              </span>
              @enderror
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Last Name*</label>
              <input type="text" required value="{{ old('last_name') }}" name="last_name" class="form-control rounded-0 form-black" id="exampleFormControlInput1">

              @error('last_name')
              <span class="text-danger">
                <code>{{ $message }}</code>
              </span>
              @enderror
            </div>
          </div>
        </div>

        <div class="mb-3">
          <div class="row">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Email Address*</label>
              <input type="email" required value="{{ old('email') }}" name="email" class="form-control rounded-0 form-black" id="exampleFormControlInput1">
              <span class="fst-italic input-note">Ex: test@gmail.com</span>

              @error('email')
              <span class="text-danger">
                <code>{{ $message }}</code>
              </span>
              @enderror
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Phone No.*</label>
              <div class="input-group">
                <span class="input-group-text bg-white rounded-0" id="basic-addon1">+63</span>
                <input type="number" required value="{{ old('phone') }}" name="phone" class="form-control rounded-0" aria-label="Username" aria-describedby="basic-addon1">
              </div>
              @error('phone')
              <span class="text-danger">
                <code>{{ $message }}</code>
              </span>
              @enderror
            </div>
          </div>
        </div>

        <div class="mb-3">
          <label for="exampleFormControlInput1" class="form-label">Complete Address*</label>
          <input type="text" required value="{{ old('address') }}" name="address" class="form-control rounded-0 form-black" id="exampleFormControlInput1">
          <span class="fst-italic input-note">Ex: Block No./Unit No., Street, Residence, Barangay, City</span>

          @error('address')
          <span class="text-danger">
            <code>{{ $message }}</code>
          </span>
          @enderror
        </div>

        {{-- <div class="mb-3">
          <label for="exampleFormControlInput1" class="form-label">Country*</label>
          <select required value="{{ old('country') }}" name="city" class="form-select rounded-0 form-black shadow-none" aria-label="Default select example">
            <option selected value="1">Philippines</option>
          </select>
        </div> --}}

        <div class="mb-3">
          <div class="row">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Assigned Date*</label>
              <input type="date" required name="assigned_date" value="{{ old('assigned_date') }}" name="first_name" class="form-control rounded-0 form-black" id="exampleFormControlInput1">

              @error('assigned_date')
              <span class="text-danger">
                <code>{{ $message }}</code>
              </span>
              @enderror
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Assigned Time*</label>
              <select name="assigned_time" id="assigned_time" class="form-control rounded-0 form-black" required>
                <option selected hidden disabled>Select a time</option>
                <option value="08:00">08:00 AM</option>
                <option value="08:30">08:30 AM</option>
                <option value="09:00">09:00 AM</option>
                <option value="09:30">09:30 AM</option>
                <option value="10:00">10:00 AM</option>
                <option value="10:30">10:30 AM</option>
                <option value="11:00">11:00 AM</option>
                <option value="11:30">11:30 AM</option>
                <option value="12:00">12:00 PM</option>
                <option value="12:30">12:30 PM</option>
                <option value="13:00">01:00 PM</option>
                <option value="13:30">01:30 PM</option>
                <option value="14:00">02:00 PM</option>
                <option value="14:30">02:30 PM</option>
                <option value="15:00">03:00 PM</option>
                <option value="15:30">03:30 PM</option>
                <option value="16:00">04:00 PM</option>
                <option value="16:30">04:30 PM</option>
                <option value="17:00">05:00 PM</option>
              </select>

              @error('assigned_time')
              <span class="text-danger">
                <code>{{ $message }}</code>
              </span>
              @enderror
            </div>
          </div>
        </div>

      </div>

      <div class="col-12 col-sm-12 col-md-12 col-lg-6">
        <label for="exampleFormControlInput1" class="form-label">Orders Notes (Optional)</label>
        <textarea type="text" rows="5" value="{{ old('notes') }}" name="notes" class="form-control rounded-0 form-black" placeholder="Note about your order ,e.g special notes for delivery." id="exampleFormControlInput1"></textarea>
      </div>
    </div>

  </section>

  {{-- ORDER --}}
  <section class="mb-5">
    <div class="bg-black p-2">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <div class="text-white">
                <span class="fw-bold">PRODUCTS</span>
              </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5">
              <div class="text-white">
                <span class="fw-bold">TOTAL</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    @if (session('cart'))
    @php
    $subtotal = $cart_total;
    $discounted = 0;
    $countProductInPromo = 0;

    if ($promo_code && $promo_code == $product_promo) {
        foreach (json_decode($product_promo, true) as $promo_id) {
            if ($promo_id == $id) {
                if ($promo_type == 'Percentage') {
                    $discounted += $subtotal * ($promo_amount / 100);
                } elseif ($promo_type == 'Fixed') {
                    $discounted += $promo_amount;
                } elseif ($promo_type == 'Percentage count') {
                    $countProductInPromo++;
                    if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                        $discounted += $subtotal * ($promo_amount / 100);
                    } else {
                        $discounted += 0;
                    }
                } elseif ($promo_type == 'Fixed count') {
                    $countProductInPromo++;
                    if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                        $discounted += $promo_amount;
                    } else {
                        $discounted += 0;
                    }
                } else {
                    $discounted += 0;
                }
            }
        }
    } else {
        if ($promo_type == 'Percentage') {
            $discounted += $subtotal * ($promo_amount / 100);
        } elseif ($promo_type == 'Fixed') {
            $discounted += $promo_amount;
        } elseif ($promo_type == 'Percentage count') {
            $countProductInPromo++;
            if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                $discounted += $subtotal * ($promo_amount / 100);
            } else {
                $discounted += 0;
            }
        } elseif ($promo_type == 'Fixed count') {
            $countProductInPromo++;
            if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                $discounted += $promo_amount;
            } else {
                $discounted += 0;
            }
        } else {
            $discounted += 0;
        }
    }
  @endphp
    @foreach (session('cart') as $id => $details)
      @if ($details['quantity'] != 0)
      {{-- @php
      $subtotal = $cart_total;
      if ($promo_code) {
        if($promo_code == $product_promo) {
          foreach (json_decode($product_promo, true) as $id) {
              if ($id == $id){
                  if ($promo_type == 'Percentage'){
                      $discounted += $cart_total * ($promo_amount / 100) ;

                  }else if ($promo_type == 'Fixed'){
                      $discounted += $details['quantity'] * ($cart_total - ($cart_total - $promo_amount));

                  }else if ($promo_type == 'Percentage count'){
                      $countProductInPromo++;
                      if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo){
                          $discounted += $cart_total * (($promo_amount / 100));

                      }else{
                          $discounted += $subtotal * (($promo_amount / 100));
                      }

                  }else if ($promo_type == 'Fixed count'){
                      $countProductInPromo++;
                      if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo){
                          $discounted = $promo_amount;
                      }else{
                          $discounted += 0;
                      }

                  }else{
                      $discounted = 0;
                  }
              }

          }
        } else {
          if ($promo_type == 'Percentage'){
                      $discounted += $cart_total * ($promo_amount / 100) ;

                  }else if ($promo_type == 'Fixed'){
                      $discounted += $details['quantity'] * ($cart_total - ($cart_total - $promo_amount));

                  }else if ($promo_type == 'Percentage count'){
                      $countProductInPromo++;
                      if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo){
                          $discounted += $cart_total * (($promo_amount / 100));

                      }else{
                          $discounted += $subtotal * (($promo_amount / 100));
                      }

                  }else if ($promo_type == 'Fixed count'){
                      $countProductInPromo++;
                      if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo){
                          $discounted = $promo_amount;
                      }else{
                          $discounted += 0;
                      }

                  }else{
                      $discounted = 0;
                  }
        }
      }
      @endphp --}}
    <div class="border border-top-0 p-2">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <div class="row">
                <div class="col-12 col-sm-12 col-md-12 col-lg-3">
                  @if ($details['shop'] == 'trends')
                  <img src="{{ asset('uploads/trends/' . $details['image'])}}" height="100" width="100" class="img-fluid" alt="">
                  @elseif ($details['shop'] == 'skins')
                  <img src="{{ asset('uploads/skins/' . $details['image'])}}" width="90" class="img-fluid" alt="">
                  @endif
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-9 d-flex align-items-center">
                  <div>
                    <span class="fw-bold">{{ $details['name'] }}</span><br>
                    @if ($details['shop'] == 'trends')
                    <span>Size {{ $details['size'] }}, Color: {{ $details['color'] }}</span><br>
                    @elseif ($details['shop'] == 'skins')
                    <span>Skincare</span><br>
                    @endif
                    <span>x {{ $details['quantity'] }}</span>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span>P {{ number_format($details['quantity'] * $details['price'], 2) }}</span>
            </div>
          </div>
        </div>
      </div>
    </div>
    @endif
    {{-- <input type="hidden" name="color[]" value="{{ $details['color'] }}">
    <input type="hidden" name="size[]" value="{{ $details['size'] }}"> --}}
    @endforeach
    @endif
    
    <div class="border border-top-0 p-4">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <span>SUBTOTAL</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span>P {{ number_format($subtotal, 2) }}</span>
            </div>
          </div>
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <span>DISCOUNTED</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span>- P {{ number_format($discounted , 2) }}</span>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="border border-top-0 p-4">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <span class="fw-bold">TOTAL</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span class="fw-bold">P {{ number_format($subtotal - $discounted, 2) }}</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  @if($promo_code)
  <input type="hidden" name="total" value="{{ number_format($subtotal - $discounted, 2) }}">
  <input type="hidden" name="cart_total" value="{{ $subtotal - $discounted }}">
  <input type="hidden" name="discount_fee" value="{{ $discounted }}">
  @endif

  <section>
    <div class="p-4 bg-light">
      <div class="mb-4">
        <span class="fs-5 fw-bold">PAYMENT MEHTHOD</span>
      </div>
      <div class="accordion mb-5" id="accordionExample">
        <div class="accordion-item border-0">
          <h2 class="accordion-header" id="headingOne">
            <button class="accordion-button border-0 bg-light shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
              <div class="form-check">
                <input class="form-check-input" type="radio" value="GCASH" name="payment_method" checked id="flexCheckDefault" required>
                <label class="form-check-label fw-bold text-black" for="flexCheckDefault">
                  GCASH
                </label>
              </div>
            </button>
          </h2>
          <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
            <div class="accordion-body bg-light">
                <p class="mb-1">Please send a check to Store Name, Store Street, Store Town, Store State / Country, Store Postcode.</p> 
                <p>Please send your Proof of Purchase together with your name on our facebook page. <a href="https://www.facebook.com/EGTRENDSAPPAREL">https://www.facebook.com/EGTRENDSAPPAREL</a></p> 
            </div>
          </div>
        </div>
        <div class="accordion-item border-0">
          <h2 class="accordion-header" id="headingTwo">
            <button class="accordion-button collapsed border-0 bg-light shadow-none" type="button"  data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
              <div class="form-check">
                <input class="form-check-input" type="radio" value="BANK TRANSFER" name="payment_method" id="flexCheckDefault1">
                <label class="form-check-label fw-bold text-black" for="flexCheckDefault1">
                  BANK TRANSFER
                </label>
              </div>
            </button>
          </h2>
          <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
            <div class="accordion-body bg-light">
              <p>Please send to this account number.</p>

              <div class="row mb-3">
                <div class="col-12 col-md-5 col-xl-5">
                  <div class="border p-3">
                    <span>Account Number: </span><span class="fw-bold">004703-0598-19</span><br>
                    <span>Name: </span><span class="fw-bold">EGLOW BEAUTY AND WELLNESS MANUFACTURING</span><br>
                    <span>Branch: </span><span class="fw-bold">0470 - BOCAUE MACARTHUR HIGHWAY</span><br>
                  </div>
                </div>
              </div>
              <p>Please send your Proof of Purchase together with your name on our facebook page. <a href="https://www.facebook.com/EGTRENDSAPPAREL">https://www.facebook.com/EGTRENDSAPPAREL</a></p> 
            </div>
          </div>
        </div>
      </div>

      <div class="form-check mb-5">
        <input class="form-check-input" type="checkbox" value="" required id="flexCheckDefault99">
        <label class="form-check-label" for="flexCheckDefault99">
          I have read and agree to the website terms and conditions.
        </label>
      </div>

      <button class="btn btn-primary shadow-none bg-transparent rounded-circle text-black py-3 px-4 align-bottom button-alt type2-alt">
        <span class="btn-text-alt">Place Order</span>
      </button>
    </div>
  </section>

  </form>

</div>
@endsection

@section('js')
<script>
  // Get all the accordion buttons
  const accordionButtons = document.querySelectorAll('.accordion-button');
  
  // Add event listeners to each accordion button
  accordionButtons.forEach(button => {
    button.addEventListener('click', function() {
      const radio = this.querySelector('.form-check-input');
      const accordionBody = this.nextElementSibling;
  
      // Check if the radio is already checked
      const isAlreadyChecked = radio.checked;
  
      // Uncheck all radios
      document.querySelectorAll('.form-check-input').forEach(radio => {
        radio.checked = false;
      });
  
      // Toggle the radio state
      radio.checked = !isAlreadyChecked;
  
      // Toggle the accordion body
      if (!isAlreadyChecked) {
        accordionBody.classList.add('show'); // Open the accordion body
      } else {
        accordionBody.classList.remove('show'); // Collapse the accordion body
      }
  
      // Collapse other accordion bodies
      accordionButtons.forEach(otherButton => {
        const otherAccordionBody = otherButton.nextElementSibling;
        if (otherButton !== button) {
          otherAccordionBody.classList.remove('show');
        }
      });
    });
  });
  
  </script>
@endsection