@extends('frontend.layouts.app')

@section('seo')
    <title>Shop | eg APPAREL</title>
    <meta property="og:locale" content="en_US" />
    <meta property="og:url" content="" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="Shop | eg APPAREL" />
    <meta property="og:description" content="" />
    <meta property="og:site_name" content="Shop | eg APPAREL" />
    <meta property="og:image" content="{{ asset('resources/web_thumb.jpg') }}" />
    <meta property="og:thumbnail" content="{{ asset('resources/web_thumb.jpg') }}" />
@endsection

@section('content')

    {{-- CONTENT --}}
    <section>
        <div class="container py-5">
            <div class="row g-5">

                <div class="col-12 col-sm-12 col-md-12 col-lg-3">
                    <div class="mb-5">
                        <h2 class="fw-bold mb-4">Search Products</h2>
                        <form action="{{ url('/search-skins') }}" method="GET">
                            <div class="input-group">
                                <span class="input-group-text rounded-0 bg-white border-end-0 bg-grey shadow-none"
                                    id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-flip-horizontal"></i></span>
                                <input type="text" name="query"
                                    class="form-control rounded-0 border-start-0 bg-grey p-2" placeholder="Search Here"
                                    aria-label="Username" aria-describedby="basic-addon1">
                            </div>
                        </form>
                    </div>

                    <form action="{{ url('filter-skins') }}" method="GET">
                        <div class="mb-5">
                            <h2 class="fw-bold mb-4">Categories</h2>
                            <div class="row g-3">
                                <div class="col-12 col-xl-6">
                                    <button type="submit" class="btn btn-outline-dark w-100">Filter <i
                                            class="fa-solid fa-filter"></i></button>
                                </div>
                                <div class="col-12 col-xl-4">
                                    <a href="{{ url('shop-skin') }}" class="btn w-100 btn-outline-danger mb-3">Clear
                                        Filter</a>
                                </div>
                            </div>
                            <div class="vstack gap-3">
                                <a href="" class="color-nude text-decoration-none">Skincare</a>
                            </div>
                        </div>

                        <h2 class="fw-bold mb-4">Price</h2>
                        <div id="slider" class="rounded-4"></div>
                        <div class="row mt-4 mb-5">
                            <div class="col-6">
                                <label for="minValue"></label>
                                <span id="minValue" class="color-nude">{{ request('min_price', '') }}</span>
                            </div>
                            <div class="col-6">
                                <label for="maxValue"></label>
                                <span id="maxValue" class="color-nude">{{ request('max_price', '') }}</span>
                            </div>
                        </div>

                        <input type="hidden" name="min_price" id="minPrice" value="{{ request('min_price', '') }}">
                        <input type="hidden" name="max_price" id="maxPrice" value="{{ request('max_price', '') }}">
                    </form>

                </div>

                <div class="col-12 col-sm-12 col-md-12 col-lg-8">
                    <div class="mb-5">
                        <h1 class="section-label">eg Skin Essentials</h1>
                        <nav aria-label="breadcrumb" class="mb-5">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ url('/') }}"
                                        class="text-black text-decoration-none fw-bold">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Shop</li>
                            </ol>
                        </nav>

                        <div class="row g-5">

                            @foreach ($skins as $items)
                                <div class="col-sm-12 col-md-12 col-lg-4">
                                    <div class="image-container">
                                        <img src="{{ asset('uploads/skins/' . $items->thumbnail) }}"
                                            class="d-block w-100 mb-5 img-shop rounded-5" alt="...">
                                        <a href="{{ url('product-view-skin/' . $items->name) }}">
                                            <div class="overlay">
                                                <div class="d-flex justify-content-center align-items-center">
                                                    <div class="rounded-circle fp-2 bg-white">
                                                        <i class="fa-solid fa-cart-shopping text-black fs-5"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                        <div class="text-center">
                                            <p class="fw-bold fs-4">{{ $items->name }}</p>
                                            <p class="fw-bold color-nude">P {{ number_format($items->price, 2) }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>

                    <div class="d-flex justify-content-center">
                        @if ($skins->hasPages())
                            <ul class="pagination pagination">

                                @if ($skins->currentPage() == 1)
                                    <a class="page-link py-1 px-3" href="#" aria-label="Previous">
                                        <i class="fa-solid fa-chevron-left"></i>
                                    </a>
                                @else
                                    <li class="page-item"><a class="page-link py-1 px-3"
                                            href="{{ $skins->previousPageUrl() }}" rel="prev"><i
                                                class="fa-solid fa-chevron-left"></i></a></li>
                                @endif



                                @if ($skins->currentPage() > 3)
                                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3"
                                            href="{{ $skins->url(1) }}">1</a></li>
                                @endif
                                @if ($skins->currentPage() > 4)
                                    <li><span>...</span></li>
                                @endif
                                @foreach (range(1, $skins->lastPage()) as $i)
                                    @if ($i >= $skins->currentPage() - 2 && $i <= $skins->currentPage() + 2)
                                        @if ($i == $skins->currentPage())
                                            <li class="page-item"><span
                                                    class="page-link py-1 px-3 active">{{ $i }}</span></li>
                                        @else
                                            <li><a class="page-link py-1 px-3"
                                                    href="{{ $skins->url($i) }}">{{ $i }}</a></li>
                                        @endif
                                    @endif
                                @endforeach
                                @if ($skins->currentPage() < $skins->lastPage() - 3)
                                    <li class="page-link py-1 px-3"><span>...</span></li>
                                @endif
                                @if ($skins->currentPage() < $skins->lastPage() - 2)
                                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3"
                                            href="{{ $skins->url($skins->lastPage()) }}">{{ $skins->lastPage() }}</a>
                                    </li>
                                @endif


                                @if ($skins->hasMorePages())
                                    <li class="page-item"><a class="page-link py-1 px-3"
                                            href="{{ $skins->previousPageUrl() }}" rel="prev"><i
                                                class="fa-solid fa-chevron-right"></i></a></li>
                                @else
                                    <a class="page-link py-1 px-3" href="#" aria-label="Next">
                                        <i class="fa-solid fa-chevron-right"></i>
                                    </a>
                                @endif
                            </ul>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </section>

    {{-- INFO --}}
    <section>
        <div class="container-fluid bg-alt">
            <div class="container py-5">
                <div class="d-flex justify-content-center">
                    <div class="row g-5 w-100">
                        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
                            <div class="hstack gap-3">
                                <i class="fa-solid fa-hand-holding-dollar fs-4"></i>
                                <div>
                                    <span class="fs-5 fw-bold">Free Delivery</span><br>
                                    <span>For all order over 99$</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
                            <div class="hstack gap-3">
                                <i class="fa-solid fa-coins fs-4"></i>
                                <div>
                                    <span class="fs-5 fw-bold">30 Days Return</span><br>
                                    <span>If goods have Problems</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
                            <div class="hstack gap-3">
                                <i class="fa-regular fa-credit-card fs-4"></i>
                                <div>
                                    <span class="fs-5 fw-bold">Secure Payment</span><br>
                                    <span>100% secure payment</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
                            <div class="hstack gap-3">
                                <i class="fa-solid fa-headset fs-4"></i>
                                <div>
                                    <span class="fs-5 fw-bold">24/7 Support</span><br>
                                    <span>Dedicated support</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('css')
    <style>
        .noUi-connect {
            background-color: #ac6c57 !important;
        }
    </style>
@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.1/nouislider.min.js"></script>
    <script>
        var slider = document.getElementById('slider');
        var minValue = document.getElementById('minValue');
        var maxValue = document.getElementById('maxValue');
        var minPrice = document.getElementById('minPrice');
        var maxPrice = document.getElementById('maxPrice');

        noUiSlider.create(slider, {
            start: [{{ request('min_price', '100') }},
                {{ request('max_price', '5000') }}
            ], // Initial values for the handles
            connect: true,
            range: {
                'min': 0,
                'max': 10000
            },
            format: {
                to: function(value) {
                    return parseInt(value);
                },
                from: function(value) {
                    return value.toString();
                }
            }
        });

        slider.noUiSlider.on('update', function(values, handle) {
            if (handle === 0) {
                minValue.innerText = values[handle];
                minPrice.value = values[handle];
            }
            if (handle === 1) {
                maxValue.innerText = values[handle];
                maxPrice.value = values[handle];
            }
        });
    </script>
@endsection
