

<?php $__env->startSection('seo'); ?>
<title>Careers | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Careers | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Careers | eg APPAREL" />
<meta property="og:image"           content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<meta property="og:thumbnail"           content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<section>
  <div class="position-relative">
    <img src="<?php echo e(asset('resources/_Banners/Banner2.jpg')); ?>" class="img-fluid" alt="">
    <div class="container">
      <div class="position-absolute translate-middle top-50 section-banner">
        <h1 class="fw-bold banner-h1">Careers</h1>
        <h2 class="fs-4">Home / Careers</h2>
      </div>
    </div>
  </div>
</section>


<section>
  <div class="container-fluid bg-alt py-5">
    <div class="container">

      <div class="row mb-5 d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-5 d-flex justify-content-center">
          <div class="input-group">
            <input type="text" class="form-control form-control-lg bg-white border-end-0 rounded-start" placeholder="Search .." aria-label="Username" aria-describedby="basic-addon1">
            <span class="input-group-text bg-white border-start-0 rounded-end" id="basic-addon1">
              <i class="fa-solid fa-magnifying-glass"></i>
            </span>
          </div>
        </div>
      </div>

      <div class="d-flex justify-content-center">
        <div class="row w-100 g-5 mb-5">

          <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <div class="rounded-3 bg-white p-5">
              <div class="row">
                <div class="col-6 col-sm-6 col-md-6 col-lg-8">
                  <div class="text-start d-flex align-items-center">
                    <h1 class="career-job"><?php echo Str::limit($items->title, 30, '...'); ?> (<?php echo e($items->vacancy); ?>)</h1>
                  </div>
                </div>
                <div class="col-6 col-sm-6 col-md-6 col-lg-4">
                  <div class="d-flex align-items-center justify-content-end">
                    <div class="bg-white rounded-circle py-1 text-center border-type px-3">
                      <span>Full Time</span>
                    </div>
                  </div>
                </div>
              </div>

              <div class="mb-3">
                <span><i class="fa-solid fa-location-dot"></i> <?php echo Str::limit($items->location, 40, '...'); ?></span> 
              </div>

              <p class="mb-4">
                <?php echo Str::limit($items->description, 100, '...'); ?>

              </p>

              <a href="<?php echo e(url('career-single/' . $items->title)); ?>" class="text-black">Learn More</a>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
      </div>

      <div class="d-flex justify-content-center mt-5">
        <nav aria-label="Page navigation example">
          <ul class="pagination">
            <li class="page-item">
              <a class="linkers mx-2 py-1 px-3" href="#" aria-label="Previous">
                <i class="fa-solid fa-chevron-left"></i>
              </a>
            </li>
            <li class="page-item"><a class="page-link mx-2 py-1 px-3" href="#">1</a></li>
            <li class="page-item"><a class="page-link mx-2 py-1 px-3 active" href="#">2</a></li>
            <li class="page-item"><a class="page-link mx-2 py-1 px-3" href="#">3</a></li>
            <li class="page-item">
              <a class="linkers mx-2 py-1 px-3" href="#" aria-label="Next">
                <i class="fa-solid fa-chevron-right"></i>
              </a>
            </li>
          </ul>
        </nav>
      </div>
      
    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
  @media only screen and (max-width: 600px) {
    .p-5{
      padding: 1rem !important;
    }
  }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rwebserver/public_html/egtrendsapparel/resources/views/frontend/pages/careers.blade.php ENDPATH**/ ?>