

<?php $__env->startSection('seo'); ?>
<title>Checkout | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Checkout | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Checkout | eg APPAREL" />
<meta property="og:image"           content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<meta property="og:thumbnail"       content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<?php
$cart_total = 0;
?>
<?php if(session('cart')): ?>
<?php $__currentLoopData = session('cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php
    $cart_total += $cart['quantity'] * $cart['price'];
    $subtotal = 0;
    $discounted = 0;
    $countProductInPromo = 0;
?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<div class="container py-5">
  <div class="text-center mb-5">
    <h1>Checkout</h1>
  </div>

  <?php if(session('success')): ?>
  <div class="col-12">
      <div class="alert alert-success my-3">
          <?php echo e(session('success')); ?>

      </div>
  </div>
  <?php endif; ?>

  
  <form method="POST" action="<?php echo e(url('payment')); ?>"><?php echo csrf_field(); ?>
  <input type="hidden" name="cart_total" value="<?php echo e($cart_total); ?>" />
  <input type="hidden" name="total" value="<?php echo e($cart_total); ?>" />
  <input type="hidden" name="service_type" value="<?php echo e($service_type); ?>" />

  <section>
    <div class="mb-5">
      <span class="fs-5 fw-bold">BILLING DETAILS</span>
    </div>
    
    <div class="row gx-5 gy-3 mb-5">
      <div class="col-12 col-sm-12 col-md-12 col-lg-6">

        <div class="mb-3">
          <div class="row">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">First Name*</label>
              <input type="text" required value="<?php echo e(old('first_name')); ?>" name="first_name" class="form-control rounded-0 form-black" id="exampleFormControlInput1">

              <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="text-danger">
                <code><?php echo e($message); ?></code>
              </span>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Last Name*</label>
              <input type="text" required value="<?php echo e(old('last_name')); ?>" name="last_name" class="form-control rounded-0 form-black" id="exampleFormControlInput1">

              <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="text-danger">
                <code><?php echo e($message); ?></code>
              </span>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
          </div>
        </div>

        <div class="mb-3">
          <div class="row">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Email Address*</label>
              <input type="email" required value="<?php echo e(old('email')); ?>" name="email" class="form-control rounded-0 form-black" id="exampleFormControlInput1">
              <span class="fst-italic input-note">Ex: test@gmail.com</span>

              <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="text-danger">
                <code><?php echo e($message); ?></code>
              </span>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Phone No.*</label>
              <div class="input-group">
                <span class="input-group-text bg-white rounded-0" id="basic-addon1">+63</span>
                <input type="number" required value="<?php echo e(old('phone')); ?>" name="phone" class="form-control rounded-0" aria-label="Username" aria-describedby="basic-addon1">
              </div>
              <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="text-danger">
                <code><?php echo e($message); ?></code>
              </span>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
          </div>
        </div>

        <div class="mb-3">
          <label for="exampleFormControlInput1" class="form-label">Complete Address*</label>
          <input type="text" required value="<?php echo e(old('address')); ?>" name="address" class="form-control rounded-0 form-black" id="exampleFormControlInput1">
          <span class="fst-italic input-note">Ex: Block No./Unit No., Street, Residence, Barangay, City</span>

          <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
          <span class="text-danger">
            <code><?php echo e($message); ?></code>
          </span>
          <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        

        <div class="mb-3">
          <div class="row">
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Assigned Date*</label>
              <input type="date" required name="assigned_date" value="<?php echo e(old('assigned_date')); ?>" name="first_name" class="form-control rounded-0 form-black" id="exampleFormControlInput1">

              <?php $__errorArgs = ['assigned_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="text-danger">
                <code><?php echo e($message); ?></code>
              </span>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <div class="col-12 col-sm-12 col-md-12 col-lg-6">
              <label for="exampleFormControlInput1" class="form-label">Assigned Time*</label>
              <select name="assigned_time" id="assigned_time" class="form-control rounded-0 form-black" required>
                <option selected hidden disabled>Select a time</option>
                <option value="08:00">08:00 AM</option>
                <option value="08:30">08:30 AM</option>
                <option value="09:00">09:00 AM</option>
                <option value="09:30">09:30 AM</option>
                <option value="10:00">10:00 AM</option>
                <option value="10:30">10:30 AM</option>
                <option value="11:00">11:00 AM</option>
                <option value="11:30">11:30 AM</option>
                <option value="12:00">12:00 PM</option>
                <option value="12:30">12:30 PM</option>
                <option value="13:00">01:00 PM</option>
                <option value="13:30">01:30 PM</option>
                <option value="14:00">02:00 PM</option>
                <option value="14:30">02:30 PM</option>
                <option value="15:00">03:00 PM</option>
                <option value="15:30">03:30 PM</option>
                <option value="16:00">04:00 PM</option>
                <option value="16:30">04:30 PM</option>
                <option value="17:00">05:00 PM</option>
              </select>

              <?php $__errorArgs = ['assigned_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
              <span class="text-danger">
                <code><?php echo e($message); ?></code>
              </span>
              <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
          </div>
        </div>

      </div>

      <div class="col-12 col-sm-12 col-md-12 col-lg-6">
        <label for="exampleFormControlInput1" class="form-label">Orders Notes (Optional)</label>
        <textarea type="text" rows="5" value="<?php echo e(old('notes')); ?>" name="notes" class="form-control rounded-0 form-black" placeholder="Note about your order ,e.g special notes for delivery." id="exampleFormControlInput1"></textarea>
      </div>
    </div>

  </section>

  
  <section class="mb-5">
    <div class="bg-black p-2">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <div class="text-white">
                <span class="fw-bold">PRODUCTS</span>
              </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5">
              <div class="text-white">
                <span class="fw-bold">TOTAL</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <?php if(session('cart')): ?>
    <?php
    $subtotal = $cart_total;
    $discounted = 0;
    $countProductInPromo = 0;

    if ($promo_code && $promo_code == $product_promo) {
        foreach (json_decode($product_promo, true) as $promo_id) {
            if ($promo_id == $id) {
                if ($promo_type == 'Percentage') {
                    $discounted += $subtotal * ($promo_amount / 100);
                } elseif ($promo_type == 'Fixed') {
                    $discounted += $promo_amount;
                } elseif ($promo_type == 'Percentage count') {
                    $countProductInPromo++;
                    if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                        $discounted += $subtotal * ($promo_amount / 100);
                    } else {
                        $discounted += 0;
                    }
                } elseif ($promo_type == 'Fixed count') {
                    $countProductInPromo++;
                    if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                        $discounted += $promo_amount;
                    } else {
                        $discounted += 0;
                    }
                } else {
                    $discounted += 0;
                }
            }
        }
    } else {
        if ($promo_type == 'Percentage') {
            $discounted += $subtotal * ($promo_amount / 100);
        } elseif ($promo_type == 'Fixed') {
            $discounted += $promo_amount;
        } elseif ($promo_type == 'Percentage count') {
            $countProductInPromo++;
            if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                $discounted += $subtotal * ($promo_amount / 100);
            } else {
                $discounted += 0;
            }
        } elseif ($promo_type == 'Fixed count') {
            $countProductInPromo++;
            if ($promo_count <= $details['quantity'] || $promo_count <= $countProductInPromo) {
                $discounted += $promo_amount;
            } else {
                $discounted += 0;
            }
        } else {
            $discounted += 0;
        }
    }
  ?>
    <?php $__currentLoopData = session('cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php if($details['quantity'] != 0): ?>
      
    <div class="border border-top-0 p-2">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <div class="row">
                <div class="col-12 col-sm-12 col-md-12 col-lg-3">
                  <?php if($details['shop'] == 'trends'): ?>
                  <img src="<?php echo e(asset('uploads/trends/' . $details['image'])); ?>" height="100" width="100" class="img-fluid" alt="">
                  <?php elseif($details['shop'] == 'skins'): ?>
                  <img src="<?php echo e(asset('uploads/skins/' . $details['image'])); ?>" width="90" class="img-fluid" alt="">
                  <?php endif; ?>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-9 d-flex align-items-center">
                  <div>
                    <span class="fw-bold"><?php echo e($details['name']); ?></span><br>
                    <?php if($details['shop'] == 'trends'): ?>
                    <span>Size <?php echo e($details['size']); ?>, Color: <?php echo e($details['color']); ?></span><br>
                    <?php elseif($details['shop'] == 'skins'): ?>
                    <span>Skincare</span><br>
                    <?php endif; ?>
                    <span>x <?php echo e($details['quantity']); ?></span>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span>P <?php echo e(number_format($details['quantity'] * $details['price'], 2)); ?></span>
            </div>
          </div>
        </div>
      </div>
    </div>
    <?php endif; ?>
    
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    
    <div class="border border-top-0 p-4">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <span>SUBTOTAL</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span>P <?php echo e(number_format($subtotal, 2)); ?></span>
            </div>
          </div>
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <span>DISCOUNTED</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span>- P <?php echo e(number_format($discounted , 2)); ?></span>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="border border-top-0 p-4">
      <div class="row d-flex justify-content-center w-100">
        <div class="col-12 col-sm-12 col-md-12 col-lg-11">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-7">
              <span class="fw-bold">TOTAL</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-5 d-flex align-items-center">
              <span class="fw-bold">P <?php echo e(number_format($subtotal - $discounted, 2)); ?></span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <?php if($promo_code): ?>
  <input type="hidden" name="total" value="<?php echo e(number_format($subtotal - $discounted, 2)); ?>">
  <input type="hidden" name="cart_total" value="<?php echo e($subtotal - $discounted); ?>">
  <input type="hidden" name="discount_fee" value="<?php echo e($discounted); ?>">
  <?php endif; ?>

  <section>
    <div class="p-4 bg-light">
      <div class="mb-4">
        <span class="fs-5 fw-bold">PAYMENT MEHTHOD</span>
      </div>
      <div class="accordion mb-5" id="accordionExample">
        <div class="accordion-item border-0">
          <h2 class="accordion-header" id="headingOne">
            <button class="accordion-button border-0 bg-light shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
              <div class="form-check">
                <input class="form-check-input" type="radio" value="GCASH" name="payment_method" checked id="flexCheckDefault" required>
                <label class="form-check-label fw-bold text-black" for="flexCheckDefault">
                  GCASH
                </label>
              </div>
            </button>
          </h2>
          <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
            <div class="accordion-body bg-light">
                <p class="mb-1">Please send a check to Store Name, Store Street, Store Town, Store State / Country, Store Postcode.</p> 
                <p>Please send your Proof of Purchase together with your name on our facebook page. <a href="https://www.facebook.com/EGTRENDSAPPAREL">https://www.facebook.com/EGTRENDSAPPAREL</a></p> 
            </div>
          </div>
        </div>
        <div class="accordion-item border-0">
          <h2 class="accordion-header" id="headingTwo">
            <button class="accordion-button collapsed border-0 bg-light shadow-none" type="button"  data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
              <div class="form-check">
                <input class="form-check-input" type="radio" value="BANK TRANSFER" name="payment_method" id="flexCheckDefault1">
                <label class="form-check-label fw-bold text-black" for="flexCheckDefault1">
                  BANK TRANSFER
                </label>
              </div>
            </button>
          </h2>
          <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
            <div class="accordion-body bg-light">
              <p>Please send to this account number.</p>

              <div class="row mb-3">
                <div class="col-12 col-md-5 col-xl-5">
                  <div class="border p-3">
                    <span>Account Number: </span><span class="fw-bold">004703-0598-19</span><br>
                    <span>Name: </span><span class="fw-bold">EGLOW BEAUTY AND WELLNESS MANUFACTURING</span><br>
                    <span>Branch: </span><span class="fw-bold">0470 - BOCAUE MACARTHUR HIGHWAY</span><br>
                  </div>
                </div>
              </div>
              <p>Please send your Proof of Purchase together with your name on our facebook page. <a href="https://www.facebook.com/EGTRENDSAPPAREL">https://www.facebook.com/EGTRENDSAPPAREL</a></p> 
            </div>
          </div>
        </div>
      </div>

      <div class="form-check mb-5">
        <input class="form-check-input" type="checkbox" value="" required id="flexCheckDefault99">
        <label class="form-check-label" for="flexCheckDefault99">
          I have read and agree to the website terms and conditions.
        </label>
      </div>

      <button class="btn btn-primary shadow-none bg-transparent rounded-circle text-black py-3 px-4 align-bottom button-alt type2-alt">
        <span class="btn-text-alt">Place Order</span>
      </button>
    </div>
  </section>

  </form>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
  // Get all the accordion buttons
  const accordionButtons = document.querySelectorAll('.accordion-button');
  
  // Add event listeners to each accordion button
  accordionButtons.forEach(button => {
    button.addEventListener('click', function() {
      const radio = this.querySelector('.form-check-input');
      const accordionBody = this.nextElementSibling;
  
      // Check if the radio is already checked
      const isAlreadyChecked = radio.checked;
  
      // Uncheck all radios
      document.querySelectorAll('.form-check-input').forEach(radio => {
        radio.checked = false;
      });
  
      // Toggle the radio state
      radio.checked = !isAlreadyChecked;
  
      // Toggle the accordion body
      if (!isAlreadyChecked) {
        accordionBody.classList.add('show'); // Open the accordion body
      } else {
        accordionBody.classList.remove('show'); // Collapse the accordion body
      }
  
      // Collapse other accordion bodies
      accordionButtons.forEach(otherButton => {
        const otherAccordionBody = otherButton.nextElementSibling;
        if (otherButton !== button) {
          otherAccordionBody.classList.remove('show');
        }
      });
    });
  });
  
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rweb/public_html/egapparel/resources/views/frontend/pages/cart/create.blade.php ENDPATH**/ ?>