

<?php $__env->startSection('seo'); ?>
<title>My Cart | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="My Cart | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="My Cart | eg APPAREL" />
<meta property="og:image"           content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<meta property="og:thumbnail"       content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
  <div class="text-center mb-5">
    <h1>My Cart</h1>
  </div>

  <?php if(session('success')): ?>
  <div class="col-12">
      <div class="alert alert-success my-1">
          <?php echo e(session('success')); ?>

      </div>
  </div>
  <?php endif; ?>
  <form method="GET" action="<?php echo e(url('cart/create')); ?>">
  <div class="row g-5">
    <div class="col-12 col-sm-12 col-md-12 col-lg-9">

      <div class="d-lg-block d-none d-sm-none">
        <table class="table mb-5">
          <thead>
            <tr>
              <th scope="col" colspan="2">PRODUCT DETAILS</th>
              <th scope="col" class="text-center">UNIT PRICE</th>
              <th scope="col" class="text-center">QUANTITY</th>
              <th scope="col" class="text-center">AMOUNT</th>
              <th scope="col"></th>
            </tr>
          </thead>

          <?php
          $cart_total = 0;
          $discounted = 0;
          $subtotal = 0;
          ?>

          <?php if(session('cart')): ?>
          <?php $__currentLoopData = session('cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
          $cart_total += $cart['quantity'] * $cart['price'];
          ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>

          <tbody>
            
            <?php if(session('cart')): ?>
            <?php $__currentLoopData = session('cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td colspan="2">
                <div class="row gx-0">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6 text-center">
                    <?php if($cart['shop'] == 'trends'): ?>
                    <img src="<?php echo e(asset('uploads/trends/' . $cart['image'])); ?>" height="100" width="100" class="img-fluid" alt="">
                    <?php elseif($cart['shop'] == 'skins'): ?>
                    <img src="<?php echo e(asset('uploads/skins/' . $cart['image'])); ?>" width="90" class="img-fluid" alt="">
                    <?php endif; ?>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <?php if($cart['shop'] == 'skins'): ?>
                    <a href="<?php echo e(url('product-view-skin/' . $cart['name'])); ?>" class="text-decoration-none text-black">
                      <span class="fw-bold text-uppercase"> <?php echo e($cart['name']); ?></span><br>
                    </a>
                  <?php else: ?>
                    <a href="<?php echo e(url('product-view-trends/' . $cart['name'])); ?>" class="text-decoration-none text-black">
                      <span class="fw-bold text-uppercase"> <?php echo e($cart['name']); ?></span><br>
                    </a>
                  <?php endif; ?>
                    <?php if($cart['shop'] == 'trends'): ?>
                    <span>Color: <?php echo e($cart['color']); ?></span><br>
                    <span>Size: <?php echo e($cart['size']); ?> | Stocks: <?php echo e($cart['stocks']); ?></span>
                    <?php elseif($cart['shop'] == 'skins'): ?>
                    <span>Skin Care | Stocks: <?php echo e($cart['stocks']); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </td>
              <td class="text-center">
                <span class="color-nude">P <?php echo e(number_format($cart['price'], 2)); ?></span>
              </td>
              <td>
                <div class="d-flex justify-content-center">
                  <div class="d-flex justify-content-center">
                    <?php if($cart['quantity'] > 0): ?>
                    <a href="<?php echo e(url('cart/' . $cart['id'])); ?>?minus=1">
                      <button type="button" id="sub" class="p-2 border-0 bg-white">-</button>
                    </a>
                    <?php endif; ?>
                    &nbsp; <div class="pt-2"><?php echo e($cart['quantity']); ?></div> &nbsp;
                    <?php if($cart['shop'] == 'trends'): ?>
                      <?php if($cart['quantity']): ?>
                        <a href="<?php echo e(url('cart/' . $cart['id'])); ?>">
                          <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                        </a>
                      <?php endif; ?>
                    <?php endif; ?>

                    <?php if($cart['shop'] == 'skins'): ?>
                      <?php if($cart['quantity'] < $cart['stocks']): ?>
                        <a href="<?php echo e(url('cart/' . $cart['id'])); ?>">
                          <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                        </a>
                      <?php endif; ?>
                    <?php endif; ?>
                  </div>
                </div>
              </td>
              <td class="text-center">
                <span class="color-nude">P <?php echo e(number_format($cart['quantity'] * $cart['price'], 2)); ?></span>
              </td>
              <td class="text-center pt-3">
                <a href="<?php echo e(url('cart/' . $cart['id'])); ?>?clear=1">
                  <i class="fa-solid fa-trash-can text-black"></i>
                </a> 
              </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </tbody>
        </table>

        <?php if(!session('cart')): ?>
        <div class="text-center">
          <span class="fs-4 fw-bold">Your Cart is Empty!</span>
        </div>

        <?php endif; ?>
      </div>

      <div class="d-lg-none d-block d-sm-block">
        <div>
          <span class="fs-6 fw-bold">PRODUCT DETAILS</span>
        </div>

        <?php if(session('cart')): ?>
        <?php $__currentLoopData = session('cart'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row mt-3">
          <div class="col-12 col-sm-12 col-md-12 col-lg-3">
            <div class="row gx-0">
              <div class="col-6 col-sm-6 col-md-6 col-lg-4 d-flex justify-content-center">
                <?php if($cart['shop'] == 'trends'): ?>
                <img src="<?php echo e(asset('uploads/trends/' . $cart['image'])); ?>" height="100" width="100" class="img-fluid" alt="">
                <?php elseif($cart['shop'] == 'skins'): ?>
                <img src="<?php echo e(asset('uploads/skins/' . $cart['image'])); ?>" width="90" class="img-fluid" alt="">
                <?php endif; ?>
              </div>
              <div class="col-6 col-sm-6 col-md-6 col-lg-8">
                <div class="mb-2">
                  <?php if($cart['shop'] == 'skins'): ?>
                    <a href="<?php echo e(url('product-view-skin/' . $cart['name'])); ?>" class="text-decoration-none">
                      <span class="fw-bold text-uppercase"> <?php echo e($cart['name']); ?></span><br>
                    </a>
                  <?php else: ?>
                    <a href="<?php echo e(url('product-view-trends/' . $cart['name'])); ?>" class="text-decoration-none">
                      <span class="fw-bold text-uppercase"> <?php echo e($cart['name']); ?></span><br>
                    </a>
                  <?php endif; ?>
                  <?php if($cart['shop'] == 'trends'): ?>
                  <span>Color: <?php echo e($cart['color']); ?> | </span><br>
                  <span>Size: <?php echo e($cart['size']); ?> | Stocks: <?php echo e($cart['stocks']); ?></span>
                  <?php elseif($cart['shop'] == 'skins'): ?>
                  <span>Skin Care | <?php echo e($cart['stocks']); ?></span>
                  <?php endif; ?>
                </div>
                <div class="d-flex justify-content-center">
                  <?php if($cart['quantity'] > 0): ?>
                  <a href="<?php echo e(url('cart/' . $cart['id'])); ?>?minus=1">
                    <button type="button" id="sub" class="p-2 border-0 bg-white">-</button>
                  </a>
                  <?php endif; ?>
                  &nbsp; <div class="pt-2"><?php echo e($cart['quantity']); ?></div> &nbsp;

                  <?php if($cart['shop'] == 'trends'): ?>
                    <?php if($cart['quantity']): ?>
                      <a href="<?php echo e(url('cart/' . $cart['id'])); ?>">
                        <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                      </a>
                    <?php endif; ?>
                  <?php else: ?>
                    <?php if($cart['quantity'] < $cart['stocks']): ?>
                      <a href="<?php echo e(url('cart/' . $cart['id'])); ?>">
                        <button type="button" id="plus" class=" p-2 border-0 bg-white">+</button>
                      </a>
                    <?php endif; ?>
                  <?php endif; ?>

                </div>
              </div>
            </div>
      
            <div class="row">
              <div class="col-4 col-sm-4 col-md-4 col-lg-4">
                <div class="text-center">
                  <span class="fs-6 fw-bold">UNIT PRICE</span>
                </div>
                <div class="text-center">
                  <span class="color-nude">P <?php echo e(number_format($cart['price'], 2)); ?></span>
                </div>
              </div>
              <div class="col-4 col-sm-4 col-md-4 col-lg-4">
                <div class="text-center">
                  <span class="fs-6 fw-bold">AMOUNT</span>
                </div>
                <div class="text-center">
                  <span class="color-nude">P <?php echo e(number_format($cart['quantity'] * $cart['price'], 2)); ?></span>
                </div>
              </div>
              <div class="col-4 col-sm-4 col-md-4 col-lg-4 d-flex align-items-center justify-content-center">
                <div>
                  <a href="<?php echo e(url('cart/' . $cart['id'])); ?>?clear=1">
                    <i class="fa-solid fa-trash-can text-black"></i>
                  </a> 
                </div>
              </div>
            </div>
            <hr>
          </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(!session('cart')): ?>
        <div class="text-center">
          <span class="fs-4 fw-bold">Your Cart is Empty!</span>
        </div>
        <?php endif; ?>
      </div>

      <div>
        <div class="row">
          <div class="col-12 col-md-4 col-xl-4">
            <label class="form-label">Discount Code:</label>
            <input type="text" name="promo_code" class="form-control rounded-0" value="<?php echo e(old('promo_code')); ?>">
            <?php $__errorArgs = ['promo_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <span class="text-danger"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-sm-12 col-md-12 col-lg-3">
      <div class="border border-bottom-0 p-4">
        <span class="fs-5 fw-bold">TOTAL</span>
      </div>
      <div class="border p-4">

        <div class="mb-2">
          <span>Service Type</span>
        </div>
        <div class="form-check mb-5">
          <input class="form-check-input" type="radio" name="service_type" value="Delivery" id="flexRadioDefault1" required>
          <label class="form-check-label" for="flexRadioDefault1">
            Delivery
          </label>
        </div>

        <hr>

        

        <div class="vstack gap-2 mb-5">
          <div class="row">
            <div class="col-6 col-sm-6 col-md-6 col-lg-6">
              <span class="fw-bold">Sub Total:</span>
            </div>
            <div class="col-6 col-sm-6 col-md-6 col-lg-6 text-end">
              <span class="fw-bold">P <?php echo e(number_format($cart_total, 2)); ?></span>
            </div>
          </div>
        </div>

        <div class="d-flex justify-content-center">
          <a href="<?php echo e(url('checkout')); ?>">
            <button class="btn btn-primary shadow-none bg-transparent w-100 rounded-circle text-black py-3 px-4 align-bottom button-alt type2-alt">
              <span class="btn-text-alt">Proceed to Checkout <i class="fa-solid fa-arrow-right-long"></i></span>
            </button>
          </a>
        </div>

      </div>
    </div>
  </div>

  </form>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
  label{
    font-family: 'Palanquin', sans-serif;
  }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rwebserver/public_html/egtrendsapparel/resources/views/frontend/pages/cart/index.blade.php ENDPATH**/ ?>