

<?php $__env->startSection('content'); ?>

<div class="p-3">
    <div class="card">
        <div class="card-header hstack">
            <span class="fw-bold">Trends Apparel Products</span>&emsp;
            <a href="<?php echo e(url('admin/trends/create')); ?>" class="text-decoration-none">
              <button type="button" class="btn btn-success">
                <i class="fas fa-edit nav-icon"></i>
                Add Product
              </button>
            </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Product Name</th>
                    <th>Thumbnail</th>
                    <th>Price</th>
                    <th>Main Category</th>
                    <th>Type</th>
                    <th>Sub Type</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    <?php $__currentLoopData = $trends; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($items->id); ?></td>
                  <td>
                    <img src="<?php echo e(asset('uploads/trends/' . $items->thumbnail)); ?>" height="50" alt="">
                  </td>
                  <td><?php echo e($items->name); ?></td>
                  <td><?php echo e($items->price, 2); ?></td>
                  <td><?php echo e($items->category); ?></td>
                  <td><?php echo e($items->type); ?></td>
                  <td><?php echo e($items->sub_type); ?></td>
                  <td class="d-flex">
                    <a href="
                    <?php echo e(url('admin/trends/' . $items->id)); ?>/edit" class="text-decoration-none">
                      <button type="button" class="btn btn-outline-primary">Edit</button>
                    </a>
                    <form action="<?php echo e(url('admin/trends/' . $items->id)); ?>" class="mx-3" method="POST"> <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                      <button class="btn btn-danger" type="submit">Delete</button>
                    </form>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<?php echo $__env->yieldContent('js'); ?>
<script>
    $(document).ready(function() {
        $('.table').DataTable({
          order: [['0', 'desc']]
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/egtrendsapparel/public_html/resources/views/backend/modules/trends/index.blade.php ENDPATH**/ ?>