

<?php $__env->startSection('seo'); ?>
<title>Shop | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Shop | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Shop | eg APPAREL" />
<meta property="og:image"           content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<meta property="og:thumbnail"       content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<section>
  <div class="container py-5">
    <div class="row g-5">

      <div class="col-12 col-sm-12 col-md-12 col-lg-3">
        <div class="mb-5">
          <h2 class="fw-bold mb-4">Search Products</h2>
          <form action="<?php echo e(url('/search-trends')); ?>" method="GET">
          <div class="input-group">
            <span class="input-group-text rounded-0 bg-white border-end-0 bg-grey" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-flip-horizontal"></i></span>
            <input type="text" name="query" class="form-control rounded-0 border-start-0 bg-grey p-2 shadow-none" placeholder="Search Here" aria-label="Username" aria-describedby="basic-addon1">
          </div>
          </form>
        </div>

        <div class="mb-5">
          <h2 class="fw-bold mb-4">Categories</h2>
          <div class="accordion mb-5" id="accordionExample">
            <form action="<?php echo e(url('filter-trends')); ?>" method="GET">

            <div class="row gx-3">
              <div class="col-12 col-xl-6">
                <button type="submit" class="btn btn-outline-dark w-100">Filter <i class="fa-solid fa-filter"></i></button>
              </div>
              <div class="col-12 col-xl-4">
                <a href="<?php echo e(url('shop-trends')); ?>" class="btn w-100 btn-outline-danger mb-3">Clear Filter</a>
              </div>
            </div>

            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingOne">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                  <input class="form-check-input category-checkbox" type="checkbox" name="category[]" value="Women Clothes" id="flexCheckDefault20" data-type="women" <?php echo e(in_array('women', request('category', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault20">
                    Women Clothes <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapseOne" class="accordion-collapse collapse <?php echo e(in_array('women', request('category', [])) ? 'show' : ''); ?>" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Tops" id="flexCheckDefault30" data-type="Tops" <?php echo e(in_array('Tops', request('type', [])) ? 'checked' : ''); ?>>
                  <label  class="form-check-label text-black" for="flexCheckDefault30">
                    Tops <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="vstack gap-2 mt-2">
                      <a class="form-check">
                        <input class="form-check-input sub-type-checkbox trend" name="sub_type[]" type="checkbox" value="tube" id="flexCheckDefault1" data-sub-type="tube" <?php echo e(in_array('Tube Tops', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault1">
                          Tube Tops
                        </label>
                      </a>
                      <a class="form-check">
                        <input class="form-check-input sub-type-checkbox" name="sub_type[]" type="checkbox" value="Polo Shirts" id="flexCheckDefault2" data-sub-type="polo" <?php echo e(in_array('Polo Shirts', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault2">
                          Polo Shirts
                        </label>
                      </a>
                      <a class="form-check">
                        <input class="form-check-input sub-type-checkbox" name="sub_type[]" type="checkbox" value="Tanks Camisoles" id="flexCheckDefault3" data-sub-type="tank" <?php echo e(in_array('Tanks Camisoles', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault3">
                          Tanks & Camisoles
                        </label>
                      </a>
                      <a class="form-check">
                        <input class="form-check-input sub-type-checkbox" name="sub_type[]" type="checkbox" value="Shirts Blouses" id="flexCheckDefault4" data-sub-type="blouse" <?php echo e(in_array('Shirts Blouses', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault4">
                          Shirts & Blouses
                        </label>
                      </a>
                    </div>
                  </div>
                  <div class="mb-3">
                    <a class="form-check">
                      <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Sweaters Cardigans" id="flexCheckDefault5" data-type="Sweaters Cardigans" <?php echo e(in_array('Sweaters Cardigans', request('type', [])) ? 'checked' : ''); ?>>
                      <label class="form-check-label text-black" for="flexCheckDefault5">
                        Sweaters & Cardigans
                      </label>
                    </a>
                  </div>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Jackets Coasts Vests" id="flexCheckDefault31" data-type="jacket" <?php echo e(in_array('Jackets Coasts Vests', request('type', [])) ? 'checked' : ''); ?>>
                  <label  class="form-check-label text-black" for="flexCheckDefault31">
                    Jackets, Coats & Vests <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="vstack gap-2 mt-2">
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Jackets" id="flexCheckDefault5" <?php echo e(in_array('Jackets', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault5">
                          Jackets
                        </label>
                      </div>
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Blazers" id="flexCheckDefault6" <?php echo e(in_array('Blazers', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault6">
                          Blazers
                        </label>
                      </div>
                    </div>
                  </div>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Hoodies Sweatshirts" id="flexCheckDefault32" data-type="Hoodies Sweatshirts" <?php echo e(in_array('Hoodies Sweatshirts', request('type', [])) ? 'checked' : ''); ?>>
                  <label  class="form-check-label text-black" for="flexCheckDefault32">
                    Hoodies & Sweatshirts <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mt-2 mb-3">
                    <div  div class="form-check">
                      <input class="form-check-input" name="sub_type[]" type="checkbox" value="Hoodies" id="flexCheckDefault7" <?php echo e(in_array('Hoodies', request('sub_type', [])) ? 'checked' : ''); ?>>
                      <label class="form-check-label text-black" for="flexCheckDefault7">
                        Hoodies
                      </label>
                    </div>
                  </div>
                  <div class="mb-3">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Dresses" id="flexCheckDefault33" data-type="Dresses" <?php echo e(in_array('Dresses', request('type', [])) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="flexCheckDefault33">
                      Dresses
                    </label>
                  </div>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Pants Leggings" id="flexCheckDefault34" data-type="Pants" <?php echo e(in_array('Pants Leggings', request('type', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault34">
                    Pants & Leggings <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="mt-2">
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Pants" id="flexCheckDefault8" <?php echo e(in_array('Pants', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault8">
                          Pants
                        </label>
                      </div>
                    </div>
                  </div>
                  <div class="mb-3">
                    <a class="form-check">
                      <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Jeans" id="flexCheckDefault19" data-type="jeans" <?php echo e(in_array('Jeans', request('type', [])) ? 'checked' : ''); ?>>
                      <label class="form-check-label text-black" for="flexCheckDefault19">
                        Jeans
                      </label>
                    </a>
                  </div>
                  <a href="" class="text-decoration-none text-black"></a>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Shorts" id="flexCheckDefault35" data-type="short" <?php echo e(in_array('Shorts', request('type', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault35">
                    Shorts <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="vstack gap-2 mt-2">
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Shorts" id="flexCheckDefault9" <?php echo e(in_array('Shorts', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault9">
                          Shorts
                        </label>
                      </div>
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Skorts" id="flexCheckDefault10" <?php echo e(in_array('Skorts', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault10">
                          Skorts
                        </label>
                      </div>
                    </div>
                  </div>
                  <div class="mb-3">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Skirts" id="flexCheckDefault36" data-type="skirt" <?php echo e(in_array('Skirts', request('type', [])) ? 'checked' : ''); ?>>
                    <label class="form-check-label text-black" for="flexCheckDefault36">
                      Skirts
                    </label>
                  </div>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Sets" id="flexCheckDefault37" data-type="set" <?php echo e(in_array('Sets', request('type', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault37">
                    Sets <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="mt-2">
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Individual Sets" id="flexCheckDefault11" <?php echo e(in_array('Individual Sets', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault11">
                          Individual Sets
                        </label>
                      </div>
                    </div>
                  </div>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Jumpsuits Playsuits Overalls" id="flexCheckDefault38" data-type="jumpsuit" <?php echo e(in_array('Jumpsuits Playsuits Overalls', request('type', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault38">
                    Jumpsuits, Playsuits & Overalls <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="mt-2">
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Jumpsuits" id="flexCheckDefault12" <?php echo e(in_array('Jumpsuits', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault12">
                          Jumpsuits
                        </label>
                      </div>
                      <div  div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="Playsuits" id="flexCheckDefault13" <?php echo e(in_array('Playsuits', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label class="form-check-label text-black" for="flexCheckDefault13">
                          Playsuits
                        </label>
                      </div>
                    </div>
                  </div>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Others" id="flexCheckDefault39" data-type="other" <?php echo e(in_array('Others', request('type', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault39">
                    Others
                  </label>
                </div>
              </div>
            </div>

            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingTwo">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                  <input class="form-check-input category-checkbox" name="category[]" type="checkbox" value="Men Clothes" id="flexCheckDefault21" data-type="men" <?php echo e(in_array('men', request('category', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault21">
                    Men Clothes <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapseTwo" class="accordion-collapse collapse  <?php echo e(in_array('men', request('category', [])) ? 'show' : ''); ?>" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Tops" id="flexCheckDefault51" data-type="Tops" <?php echo e(in_array('Tops', request('type', [])) ? 'checked' : ''); ?>>
                  <label  class="form-check-label text-black" for="flexCheckDefault50">
                    Tops <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3">
                    <div class="vstack gap-2 mt-3">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Shirts" id="flexCheckDefault14" <?php echo e(in_array('Shirts', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault14">
                          Shirts
                        </label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Polo Shirts" id="flexCheckDefault15" <?php echo e(in_array('Polo Shirts', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault15">
                          Polo Shirts
                        </label>
                      </div>
                      <div  div class="form-check">
                        <input class="form-check-input" type="checkbox" value="T-Shirts" id="flexCheckDefault16" <?php echo e(in_array('T-Shirts', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault16">
                          T-Shirts
                        </label>
                      </div>
                    </div>
                  </div>
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Pants" id="flexCheckDefault51" data-type="pants" <?php echo e(in_array('Pants', request('type', [])) ? 'checked' : ''); ?>>
                  <label  class="form-check-label text-black" for="flexCheckDefault51">
                    Pants <i class="fa-solid fa-angle-right"></i>
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="vstack gap-2 mt-2">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Pants" id="flexCheckDefault17" <?php echo e(in_array('Pants', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault17">
                          Pants
                        </label>
                      </div>
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="cargo" id="flexCheckDefault18" <?php echo e(in_array('cargo', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault18">
                          Cargo
                        </label>
                      </div>
                    </div>
                  </div>
                  <div class="mb-3">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Shorts" id="flexCheckDefault53" data-type="shorts" <?php echo e(in_array('Shorts', request('type', [])) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="flexCheckDefault53">
                      Shorts
                    </label>
                  </div>
                  <div class="mb-3">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="hoodies" id="flexCheckDefault54" data-type="hoodies" <?php echo e(in_array('shorts', request('type', [])) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="flexCheckDefault54">
                      Hoodies & Sweatshirts
                    </label>
                  </div>
                  <div class="mb-3">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="other" id="flexCheckDefault55" data-type="other" <?php echo e(in_array('other', request('type', [])) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="flexCheckDefault55">
                      Others
                    </label>
                  </div>
                </div>
              </div>
            </div>

            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingThree">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="false" aria-controls="collapseTwo">
                  <input class="form-check-input category-checkbox" name="category[]" type="checkbox" value="Watches" id="flexCheckDefault22" data-type="watch" <?php echo e(in_array('watch', request('category', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault22">
                    Watches <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse3" class="accordion-collapse collapse  <?php echo e(in_array('watch', request('category', [])) ? 'show' : ''); ?>" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Watches Accessories" id="flexCheckDefault53" data-type="watches" <?php echo e(in_array('Watches Accessories', request('type', [])) ? 'checked' : ''); ?>>
                  <label  class="form-check-label text-black" for="flexCheckDefault53">
                    Watches Accessories
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="vstack gap-2 mt-2">
                      <div class="form-check">
                        <input class="form-check-input" name="sub_type[]" type="checkbox" value="battery" id="flexCheckDefault15" <?php echo e(in_array('battery', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault15">
                          Batteries
                        </label>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingThree">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed mb-3" type="button" data-bs-toggle="collapse" data-bs-target="#collapse4" aria-expanded="false" aria-controls="collapseTwo">
                  <input class="form-check-input category-checkbox" name="category[]" type="checkbox" value="Baby Kids Fashion" id="flexCheckDefault23" data-type="Baby_Kids" <?php echo e(in_array('baby', request('category', [])) ? 'checked' : ''); ?>>
                  <label class="form-check-label text-black" for="flexCheckDefault23">
                    Baby & Kids Fashion <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse4" class="accordion-collapse collapse  <?php echo e(in_array('baby', request('category', [])) ? 'show' : ''); ?>" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Girl Clothes" id="flexCheckDefault56" data-type="girl_clothes" <?php echo e(in_array('Girl Clothes', request('type', [])) ? 'checked' : ''); ?>>
                  <label  class="form-check-label text-black" for="flexCheckDefault56">
                    Girl Clothes
                  </label>
                  <div class="ps-3 mb-3">
                    <div class="vstack gap-2 mt-2">
                      <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Swimwear" id="flexCheckDefault15" <?php echo e(in_array('Swimwear', request('sub_type', [])) ? 'checked' : ''); ?>>
                        <label  class="form-check-label text-black" for="flexCheckDefault15">
                          Swimwear
                        </label>
                      </div>
                    </div>
                  </div>

                  <div class="form-check">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="Baby Clothes" id="flexCheckDefault56" data-type="baby_clothes" <?php echo e(in_array('Baby Clothes', request('type', [])) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="flexCheckDefault56">
                      Baby Clothes
                    </label>
                  </div>

                </div>
              </div>
            </div>

            <div class="mb-2">
              <div class="form-check">
                <input class="form-check-input category-checkbox" name="category[]" type="checkbox" value="Mesh Fabric" id="flexCheckDefault17" data-type="mesh" <?php echo e(in_array('mesh', request('category', [])) ? 'checked' : ''); ?>>
                <label  class="form-check-label text-black" for="flexCheckDefault17">
                  Mesh Fabric
                </label>
              </div>
            </div>

            <div>
              <div class="form-check">
                <input class="form-check-input category-checkbox" name="category[]" type="checkbox" value="Sports Outdoor" id="flexCheckDefault18" data-type="mesh" <?php echo e(in_array('sports', request('category', [])) ? 'checked' : ''); ?>>
                <label  class="form-check-label text-black" for="flexCheckDefault18">
                  Sports & Outdoors
                </label>
              </div>
            </div>

          </div>
        </div>

        <h2 class="fw-bold mb-4">Price</h2>
        <div id="slider" class="rounded-4"></div>
        <div class="row mt-4 mb-5">
            <div class="col-6">
                <label for="minValue"></label>
                <span id="minValue" class="color-trends"><?php echo e(request('min_price', '')); ?></span>
            </div>
            <div class="col-6">
                <label for="maxValue"></label>
                <span id="maxValue" class="color-trends"><?php echo e(request('max_price', '')); ?></span>
            </div>
        </div>

        <input type="hidden" name="min_price" id="minPrice" value="<?php echo e(request('min_price', '')); ?>">
        <input type="hidden" name="max_price" id="maxPrice" value="<?php echo e(request('max_price', '')); ?>">

        

      </form>
      </div>

      <div class="col-12 col-sm-12 col-md-12 col-lg-8">
        <div class="mb-5">
          <h1 class="section-label">eg Trends Apparel</h1>
          <nav aria-label="breadcrumb" class="mb-5">
            <ol class="breadcrumb">
              <li class="breadcrumb-item alt"><a href="<?php echo e(url('/')); ?>" class="text-black text-decoration-none fw-bold">Home</a></li>
              <li class="breadcrumb-item alt active" aria-current="page">Shop</li>
            </ol>
          </nav>
  
          <div class="row g-5">
            
            <?php $__currentLoopData = $trends; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-sm-12 col-md-12 col-lg-4 trend-item">
              <div class="image-container">
                <img src="<?php echo e(asset('uploads/trends/' . $items->thumbnail)); ?>" class="d-block w-100 mb-5 img-shop rounded-5" alt="...">
                <div class="overlay">
                  <div class="d-flex justify-content-center align-items-center">
                    <a href="<?php echo e(url('product-view-trends/' . $items->name)); ?>">
                      <div class="rounded-circle p-2 bg-white">
                        <i class="fa-solid fa-cart-shopping text-black fs-5"></i>
                      </div>
                    </a>
                  </div>
                </div>
                <div class="text-center">
                  <p class="fw-bold fs-4"><?php echo e($items->name); ?></p>
                  <p class="fw-bold color-trends">P <?php echo e(number_format($items->price, 2)); ?></p>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

          </div>
        </div>

        

        <div class="d-flex justify-content-center">
          <?php if($trends->hasPages()): ?>
            <ul class="pagination pagination">
  
            <?php if($trends->currentPage() == 1): ?>
                <a class="page-link py-1 px-3" href="#" aria-label="Previous">
                  <i class="fa-solid fa-chevron-left"></i>
                </a>
            <?php else: ?>
                <li class="page-item"><a class="page-link py-1 px-3" href="<?php echo e($trends->previousPageUrl()); ?>" rel="prev"><i class="fa-solid fa-chevron-left"></i></a></li>
            <?php endif; ?>
            
        
        
                <?php if($trends->currentPage() > 3): ?>
                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3" href="<?php echo e($trends->url(1)); ?>">1</a></li>
                <?php endif; ?>
                <?php if($trends->currentPage() > 4): ?>
                    <li><span>...</span></li>
                <?php endif; ?>
                <?php $__currentLoopData = range(1, $trends->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($i >= $trends->currentPage() - 2 && $i <= $trends->currentPage() + 2): ?>
                        <?php if($i == $trends->currentPage()): ?>
                            <li class="page-item"><span class="page-link py-1 px-3 active"><?php echo e($i); ?></span></li>
                        <?php else: ?>
                            <li><a class="page-link py-1 px-3" href="<?php echo e($trends->url($i)); ?>"><?php echo e($i); ?></a></li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($trends->currentPage() < $trends->lastPage() - 3): ?>
                    <li class="page-link py-1 px-3"><span>...</span></li>
                <?php endif; ?>
                <?php if($trends->currentPage() < $trends->lastPage() - 2): ?>
                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3" href="<?php echo e($trends->url($trends->lastPage())); ?>"><?php echo e($trends->lastPage()); ?></a></li>
                <?php endif; ?>
        
  
                <?php if($trends->hasMorePages()): ?>
                <li class="page-item"><a class="page-link py-1 px-3" href="<?php echo e($trends->previousPageUrl()); ?>" rel="prev"><i class="fa-solid fa-chevron-right"></i></a></li>
                <?php else: ?>
                <a class="page-link py-1 px-3" href="#" aria-label="Next">
                  <i class="fa-solid fa-chevron-right"></i>
                </a>
                <?php endif; ?>
            </ul>
          <?php endif; ?>
        </div>

      </div>
    </div>
  </div>
</section>


<section>
<div class="container-fluid bg-alt">
  <div class="container py-5">
    <div class="d-flex justify-content-center">
      <div class="row g-5 w-100">
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-hand-holding-dollar fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">Free Delivery</span><br>
              <span>For all order over 99$</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-coins fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">30 Days Return</span><br>
              <span>If goods have Problems</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-regular fa-credit-card fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">Secure Payment</span><br>
              <span>100% secure payment</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-headset fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">24/7 Support</span><br>
              <span>Dedicated support</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
  .noUi-connect{
  background-color: #fc4c1b !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
  // Get the accordion button element
var accordionButton = document.querySelector('.accordion-header button');

// Get the checkbox element
var checkbox = document.querySelector('.category-checkbox');

// Add a click event listener to the accordion button
accordionButton.addEventListener('click', function() {
  // Check if the accordion button is expanded or collapsed
  var isExpanded = accordionButton.getAttribute('aria-expanded') === 'true';
  
  // Toggle the checkbox based on the accordion button state
  checkbox.checked = isExpanded;
});
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.1/nouislider.min.js"></script>
<script>
  var slider = document.getElementById('slider');
  var minValue = document.getElementById('minValue');
  var maxValue = document.getElementById('maxValue');
  var minPrice = document.getElementById('minPrice');
  var maxPrice = document.getElementById('maxPrice');

  noUiSlider.create(slider, {
    start: [<?php echo e(request('min_price', '100')); ?>, <?php echo e(request('max_price', '5000')); ?>], // Initial values for the handles
    connect: true,
    range: {
      'min': 0,
      'max': 10000
    },
    format: {
      to: function (value) {
        return parseInt(value);
      },
      from: function (value) {
        return value.toString();
      }
    }
  });

  slider.noUiSlider.on('update', function (values, handle) {
    if (handle === 0) {
      minValue.innerText = values[handle];
      minPrice.value = values[handle];
    }
    if (handle === 1) {
      maxValue.innerText = values[handle];
      maxPrice.value = values[handle];
    }
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\czed\EG APPAREL\EG APPAREL\resources\views/frontend/pages/shop-trends.blade.php ENDPATH**/ ?>