

<?php $__env->startSection('content'); ?>

<div class="p-3">
  <div class="card">
      <div class="card-header fw-bold">
        <span class="fw-bold">Careers</span>&emsp;
        <a href="<?php echo e(url('admin/careers/create')); ?>" class="text-decoration-none">
          <button type="button" class="btn btn-success">
            <i class="fas fa-edit nav-icon"></i>
            Add Career
          </button>
        </a>
      </div>
      <div class="card-body">
          <table class="table table-striped" style="width:100%">
              <thead>
                <tr>
                  <th>Position</th>
                  <th>Vacancy</th>
                  <th>Location</th>
                  <th>Description</th>
                  <th>Action</th>
                </tr>
              </thead>
              
              <tbody>
                <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td><?php echo e($items->title); ?></td>
                      <td><?php echo e($items->vacancy); ?></td>
                      <td><?php echo e($items->location); ?></td>
                      <td><?php echo $items->description; ?></td>
                      <td>
                        <div class="d-flex">
                          <a href="<?php echo e(url('admin/careers/' .$items->id)); ?>/edit">
                            <button type="button" class="btn btn-outline-primary">Edit</button>
                          </a>
                          <form action="<?php echo e(url('admin/careers/' .$items->id)); ?>/edit" 
                            method="POST" class="mx-3"> <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                            <button class="btn btn-danger" type="submit">Delete</button>
                          </form>
                        </div>
                      </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
              
            </table>
      </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready( function () {
    $('.table').DataTable();
} );
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/egtrendsapparel/public_html/resources/views/backend/modules/careers/index.blade.php ENDPATH**/ ?>