

<?php $__env->startSection('seo'); ?>
<title>Shop | eg APPAREL</title>
<meta property="og:locale"          content="en_US" />
<meta property="og:url"             content="" />
<meta property="og:type"            content="website" />
<meta property="og:title"           content="Shop | eg APPAREL" />
<meta property="og:description"     content="" />
<meta property="og:site_name"       content="Shop | eg APPAREL" />
<meta property="og:image"           content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<meta property="og:thumbnail"       content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<section>
  <div class="container py-5">
    <div class="row g-5">

      <div class="col-12 col-sm-12 col-md-12 col-lg-3">
        <form id="filter-form" action="<?php echo e(url('filter-trends')); ?>" method="GET">
        <div class="mb-5">
          <h2 class="fw-bold mb-4">Search Products</h2>
          <div class="input-group">
            <span class="input-group-text rounded-0 bg-white border-end-0 bg-grey" id="basic-addon1"><i class="fa-solid fa-magnifying-glass fa-flip-horizontal"></i></span>
            <input type="text" name="query" class="form-control rounded-0 border-start-0 bg-grey p-2 shadow-none" placeholder="Search Here" aria-describedby="basic-addon1">
          </div>
        </div>

        <div class="mb-5">
          <h2 class="fw-bold mb-4">Categories</h2>
          <div class="accordion mb-5" id="accordionExample">
              <div class="row gy-3 justify-content-center">
                <div class="col-12 col-md">
                  <button type="submit" class="btn btn-outline-dark w-100">Filter <i class="fa-solid fa-filter"></i></button>
                </div>
                <div class="col-12 col-md">
                  <a href="<?php echo e(url('shop-trends')); ?>" class="btn w-100 btn-outline-danger mb-3">Clear Filter</a>
                </div>
              </div>
            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingOne">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="true" aria-controls="collapseOne">
                  <label class="form-check-label text-black" for="flexCheckDefault1">
                    Main Category <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse1" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="form-check">
                    <input class="form-check-input type-checkbox" name="category[]" type="checkbox" value="<?php echo e($cat->name); ?>" id="category<?php echo e($cat->id); ?>" data-type="<?php echo e($cat->name); ?>" <?php echo e(in_array($cat->name, (array) request('category')) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="category<?php echo e($cat->id); ?>">
                      <?php echo e($cat->name); ?>

                    </label>
                  </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
            </div>
            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingOne">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="true" aria-controls="collapseOne">
                  <label class="form-check-label text-black" for="flexCheckDefault2">
                    Type <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse2" class="accordion-collapse collapse <?php echo e(in_array('women', request('category', [])) ? 'show' : ''); ?>" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="form-check">
                    <input class="form-check-input type-checkbox" name="type[]" type="checkbox" value="<?php echo e($type->type); ?>" id="type<?php echo e($type->id); ?>" data-type="<?php echo e($type->type); ?>" <?php echo e(in_array($type->type, (array) request('type')) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="type<?php echo e($type->id); ?>">
                      <?php echo e($type->type); ?>

                    </label>
                  </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
            </div>
            <div class="accordion-item border-0">
              <h2 class="accordion-header" id="headingOne">
                <button class="trends-category fs-6 text-decoration-none border-0 bg-transparent p-0 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse3" aria-expanded="true" aria-controls="collapseOne">
                  <label class="form-check-label text-black" for="flexCheckDefault2">
                    Sub Types <i class="fa-solid fa-angle-right"></i>
                  </label>
                </button>
              </h2>
              <div id="collapse3" class="accordion-collapse collapse <?php echo e(in_array('women', request('category', [])) ? 'show' : ''); ?>" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                <div class="accordion-body pt-2">
                  <?php $__currentLoopData = $sub; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="form-check">
                    <input class="form-check-input type-checkbox" name="sub_type[]" type="checkbox" value="<?php echo e($subs->sub_type); ?>" id="sub<?php echo e($subs->id); ?>" data-type="<?php echo e($subs->sub_type); ?>" <?php echo e(in_array($subs->sub_type, (array) request('sub_type')) ? 'checked' : ''); ?>>
                    <label  class="form-check-label text-black" for="sub<?php echo e($subs->id); ?>">
                      <?php echo e($subs->sub_type); ?>

                    </label>
                  </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
            </div>
          </div>
        </div>

        <h2 class="fw-bold mb-4">Price</h2>
        <div id="slider" class="rounded-4"></div>
        <div class="row mt-4 mb-5">
            <div class="col-6">
                <label for="minValue"></label>
                <span id="minValue" class="color-trends"><?php echo e(request('min_price', '')); ?></span>
            </div>
            <div class="col-6">
                <label for="maxValue"></label>
                <span id="maxValue" class="color-trends"><?php echo e(request('max_price', '')); ?></span>
            </div>
        </div>

        <input type="hidden" name="min_price" id="minPrice" value="<?php echo e(request('min_price', '')); ?>">
        <input type="hidden" name="max_price" id="maxPrice" value="<?php echo e(request('max_price', '')); ?>">

        </form>
      </div>

      <div class="col-12 col-sm-12 col-md-12 col-lg-8">
        <div class="mb-5">
          <h1 class="section-label">eg Trends Apparel</h1>
          <nav aria-label="breadcrumb" class="mb-5">
            <ol class="breadcrumb">
              <li class="breadcrumb-item alt"><a href="<?php echo e(url('/')); ?>" class="text-black text-decoration-none fw-bold">Home</a></li>
              <li class="breadcrumb-item alt active" aria-current="page">Shop</li>
            </ol>
          </nav>
  
          <div class="row g-5">
            
            <?php $__currentLoopData = $trends; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-sm-12 col-md-12 col-lg-4 trend-item">
              <div class="image-container">
                <img src="<?php echo e(asset('uploads/trends/' . $items->thumbnail)); ?>" class="d-block w-100 mb-5 img-shop rounded-5" alt="...">
                <div class="overlay">
                  <div class="d-flex justify-content-center align-items-center">
                    <a href="<?php echo e(url('product-view-trends/' . $items->name)); ?>">
                      <div class="rounded-circle p-2 bg-white">
                        <i class="fa-solid fa-cart-shopping text-black fs-5"></i>
                      </div>
                    </a>
                  </div>
                </div>
                <div class="text-center">
                  <p class="fw-bold fs-4"><?php echo e($items->name); ?></p>
                  <p class="fw-bold color-trends">P <?php echo e(number_format($items->price, 2)); ?></p>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

          </div>
        </div>

        

        <div class="d-flex justify-content-center">
          <?php if($trends->hasPages()): ?>
            <ul class="pagination pagination">
  
            <?php if($trends->currentPage() == 1): ?>
                <a class="page-link py-1 px-3" href="#" aria-label="Previous">
                  <i class="fa-solid fa-chevron-left"></i>
                </a>
            <?php else: ?>
                <li class="page-item"><a class="page-link py-1 px-3" href="<?php echo e($trends->previousPageUrl()); ?>" rel="prev"><i class="fa-solid fa-chevron-left"></i></a></li>
            <?php endif; ?>
            
        
        
                <?php if($trends->currentPage() > 3): ?>
                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3" href="<?php echo e($trends->url(1)); ?>">1</a></li>
                <?php endif; ?>
                <?php if($trends->currentPage() > 4): ?>
                    <li><span>...</span></li>
                <?php endif; ?>
                <?php $__currentLoopData = range(1, $trends->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($i >= $trends->currentPage() - 2 && $i <= $trends->currentPage() + 2): ?>
                        <?php if($i == $trends->currentPage()): ?>
                            <li class="page-item"><span class="page-link py-1 px-3 active"><?php echo e($i); ?></span></li>
                        <?php else: ?>
                            <li><a class="page-link py-1 px-3" href="<?php echo e($trends->url($i)); ?>"><?php echo e($i); ?></a></li>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($trends->currentPage() < $trends->lastPage() - 3): ?>
                    <li class="page-link py-1 px-3"><span>...</span></li>
                <?php endif; ?>
                <?php if($trends->currentPage() < $trends->lastPage() - 2): ?>
                    <li class="page-item hidden-xs"><a class="page-link py-1 px-3" href="<?php echo e($trends->url($trends->lastPage())); ?>"><?php echo e($trends->lastPage()); ?></a></li>
                <?php endif; ?>
        
  
                <?php if($trends->hasMorePages()): ?>
                <li class="page-item"><a class="page-link py-1 px-3" href="<?php echo e($trends->previousPageUrl()); ?>" rel="prev"><i class="fa-solid fa-chevron-right"></i></a></li>
                <?php else: ?>
                <a class="page-link py-1 px-3" href="#" aria-label="Next">
                  <i class="fa-solid fa-chevron-right"></i>
                </a>
                <?php endif; ?>
            </ul>
          <?php endif; ?>
        </div>

      </div>
    </div>
  </div>
</section>


<section>
<div class="container-fluid bg-alt">
  <div class="container py-5">
    <div class="d-flex justify-content-center">
      <div class="row g-5 w-100">
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-hand-holding-dollar fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">Free Delivery</span><br>
              <span>For all order over 99$</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-coins fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">30 Days Return</span><br>
              <span>If goods have Problems</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-regular fa-credit-card fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">Secure Payment</span><br>
              <span>100% secure payment</span>
            </div>
          </div>
        </div>
        <div class="col-sm-12 col-md-12 col-lg-3 d-flex justify-content-center align-items-center">
          <div class="hstack gap-3">
            <i class="fa-solid fa-headset fs-4"></i>
            <div>
              <span class="fs-5 fw-bold">24/7 Support</span><br>
              <span>Dedicated support</span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
  .noUi-connect{
  background-color: #fc4c1b !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script>
  // Get the accordion button element
var accordionButton = document.querySelector('.accordion-header button');

// Get the checkbox element
var checkbox = document.querySelector('.category-checkbox');

// Add a click event listener to the accordion button
accordionButton.addEventListener('click', function() {
  // Check if the accordion button is expanded or collapsed
  var isExpanded = accordionButton.getAttribute('aria-expanded') === 'true';
  
  // Toggle the checkbox based on the accordion button state
  checkbox.checked = isExpanded;
});
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.1/nouislider.min.js"></script>
<script>
  var slider = document.getElementById('slider');
  var minValue = document.getElementById('minValue');
  var maxValue = document.getElementById('maxValue');
  var minPrice = document.getElementById('minPrice');
  var maxPrice = document.getElementById('maxPrice');

  noUiSlider.create(slider, {
    start: [<?php echo e(request('min_price', '100')); ?>, <?php echo e(request('max_price', '5000')); ?>], // Initial values for the handles
    connect: true,
    range: {
      'min': 0,
      'max': 10000
    },
    format: {
      to: function (value) {
        return parseInt(value);
      },
      from: function (value) {
        return value.toString();
      }
    }
  });

  slider.noUiSlider.on('update', function (values, handle) {
    if (handle === 0) {
      minValue.innerText = values[handle];
      minPrice.value = values[handle];
    }
    if (handle === 1) {
      maxValue.innerText = values[handle];
      maxPrice.value = values[handle];
    }
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/egtrends/public_html/resources/views/frontend/pages/shop-trends.blade.php ENDPATH**/ ?>