

<?php $__env->startSection('content'); ?>

<div class="p-3">
    <div class="card">
        <div class="card-header hstack">
            <span class="fw-bold">Skin Essentials Products</span>&emsp;
            <a href="<?php echo e(url('admin/skins/create')); ?>" class="text-decoration-none">
              <button type="button" class="btn btn-success">
                <i class="fas fa-edit nav-icon"></i>
                Add Product
              </button>
            </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Product Thumbnail</th>
                    <th>Product Name</th>
                    <th>Price</th>
                    <th>Stocks</th>
                    <th>Ingredients</th>
                    <th>Reviews</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    <?php $__currentLoopData = $skins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($items->id); ?></td>
                    <td>
                      <img src="<?php echo e(asset('uploads/skins/' . $items->thumbnail)); ?>" height="50" alt="">
                    </td>
                    <td><?php echo e($items->name); ?></td>
                    <td><?php echo e($items->price, 2); ?></td>
                    <td><?php echo e($items->stocks); ?></td>
                    <td><?php echo e($items->ingredients); ?></td>
                    <td><?php echo e($items->reviews); ?></td>
                    <td class="d-flex">
                      <a href="
                      <?php echo e(url('admin/skins/' . $items->id)); ?>/edit" class="text-decoration-none">
                        <button type="button" class="btn btn-outline-primary">Edit</button>
                      </a>
                      <form action="<?php echo e(url('admin/skins/' . $items->id)); ?>" method="POST" class="mx-3"> <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                        <button class="btn btn-danger" type="submit">Delete</button>
                      </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<?php echo $__env->yieldContent('js'); ?>
<script>
    $(document).ready(function() {
        $('.table').DataTable({
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rweb/public_html/egapparel/resources/views/backend/modules/skins/index.blade.php ENDPATH**/ ?>