

<?php $__env->startSection('content'); ?>

<div class="p-3">
    <div class="card">
        <div class="card-header fw-bold">
          <span class="fw-bold">Blogs</span>&emsp;
          <a href="<?php echo e(url('admin/blogs/create')); ?>" class="text-decoration-none">
            <button type="button" class="btn btn-success">
              <i class="fas fa-edit nav-icon"></i>
              Add Blog
            </button>
          </a>
        </div>
        <div class="card-body">
            <table class="table table-striped" style="width:100%">
                <thead>
                  <tr>
                    <th>Thumbnail</th>
                    <th>Title</th>
                    <th>Author</th>
                    <th>Description</th>
                    <th>Action</th>
                  </tr>
                </thead>
                
                <tbody>
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                      <img src="<?php echo e(asset('uploads/blogs/' . $items->thumbnail)); ?>" height="50" alt="">
                    </td>
                    <td><?php echo e($items->title); ?></td>
                    <td><?php echo e($items->author); ?></td>
                    <td><?php echo Str::limit($items->description, 100, '...'); ?></td>
                    <td class="d-flex">
                      <a href="<?php echo e(url('admin/blogs/' .$items->id)); ?>/edit" class="text-decoration-none">
                        <button type="button" class="btn btn-outline-primary">Edit</button>
                      </a>
                      <form action="<?php echo e(url('admin/blogs/' . $items->id )); ?>" method="POST" class="mx-3"> <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                        <button class="btn btn-danger" type="submit">Delete</button>
                      </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.js"></script>
<script>
  $(document).ready( function () {
    $('.table').DataTable();
} );
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\czed\EG APPAREL\resources\views/backend/modules/blogs/index.blade.php ENDPATH**/ ?>