<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Palanquin:wght@400;700&family=Viaoda+Libre&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.1/nouislider.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    
    <link rel="icon" href="<?php echo e(asset('resources/favicon.ico')); ?>">
</head>
<?php echo $__env->yieldContent('seo'); ?>
<?php $__env->startSection('seo'); ?>
    <meta property="og:locale" content="en_US" />
    <meta property="og:url" content="" />
    <meta property="og:type" content="website" />
    <meta property="og:title" content="eg APPAREL" />
    <meta property="og:description" content="" />
    <meta property="og:site_name" content="eg APPAREL" />
    <meta property="og:image" content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
    <meta property="og:thumbnail" content="<?php echo e(asset('resources/web_thumb.jpg')); ?>" />
<?php $__env->stopSection(); ?>

<body>

    <div class="preloader position-fixed translate-middle start-50 top-50">
        <div class="position-fixed translate-middle start-50 top-50">
            <div class="loader"></div>
        </div>
    </div>

    
    <nav class="navbar sticky-top navbar-expand-lg bg-white">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(asset('resources/eg-weblogo1.png')); ?>" class="img-fluid" alt="">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                    <li class="nav-item mx-4">
                        <a class="nav-link <?php echo e(request()->is('/') ? 'link-active' : ''); ?>" aria-current="page"
                            href="<?php echo e(url('/')); ?>">Home</a>
                    </li>
                    <li class="nav-item mx-4">
                        <a class="nav-link <?php echo e(request()->is('about-us') ? 'link-active' : ''); ?>"
                            href="<?php echo e(url('about-us')); ?>">About Us</a>
                    </li>
                    <li class="nav-item mx-4">
                        <!-- Example split danger button -->
                        <div class="btn-group">
                            <a type="button" class="btn nav-link">Our Shop</a>
                            <button type="button"
                                class="btn dropdown-toggle dropdown-toggle-split shadow-none border-none"
                                data-bs-toggle="dropdown" aria-expanded="false">
                                <span class="visually-hidden">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu border-0 rounded-0">
                                <li><a class="dropdown-item" href="<?php echo e(url('shop-skin')); ?>">eg Skin Essentials</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(url('shop-trends')); ?>">eg Trends Apparel</a></li>
                            </ul>
                        </div>
                    </li>
                    <li class="nav-item mx-4">
                        <a class="nav-link <?php echo e(request()->is('blogs') ? 'link-active' : ''); ?>"
                            href="<?php echo e(url('blogs')); ?>">Blogs</a>
                    </li>
                    <li class="nav-item mx-4">
                        <a class="nav-link <?php echo e(request()->is('contact-us') ? 'link-active' : ''); ?>"
                            href="<?php echo e(url('contact-us')); ?>">Contact Us</a>
                    </li>
                </ul>
                <div class="hstack gap-4">
                    <a href="<?php echo e(url('/cart')); ?>" class="text-black text-decoration-none"><i
                            class="fa-solid fa-cart-shopping"></i>
                        <?php if(session('cart')): ?>
                            <?php if(count(session('cart'))): ?>
                                <span class="blue fw-bold">(<?php echo e(count(session('cart'))); ?>)</span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </a>
                    <button class="btn btn-primary bg-white border-0 shadow-none w-25 text-start" type="button"
                        data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight">
                        <i class="fa-solid fa-bars text-black"></i>
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
        <div class="offcanvas-header justify-content-end">
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body text-center">
            <img src="<?php echo e(asset('resources/eg-weblogo1.png')); ?>" class="img-fluid mb-5" alt="">

            <div class="d-flex justify-content-center">
                <div class="vstack gap-3">
                    <a href="<?php echo e(url('brands')); ?>" class="text-black text-decoration-none fs-5">Brands</a>
                    <a href="<?php echo e(url('careers')); ?>" class="text-black text-decoration-none fs-5">Careers</a>
                </div>
            </div>
        </div>
    </div>

    <div>
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    
    <footer class="overflow-hidden">
        <div class="container my-5 py-5">
            <div class="row g-5">
                <div class="col-12 col-sm-12 col-md-12 col-lg">
                    <h3 class="fw-bold mb-5">Contact Us</h3>

                    <span>1250 Penn Avenue Pittsburgh</span><br>
                    <span>Pennsylvania 15222</span><br>
                    <span>Philippines</span>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg">
                    <h3 class="fw-bold mb-5">Useful links</h3>
                    <div class="lh-lg">
                        <a href="<?php echo e(url('/')); ?>"
                            class="text-black text-decoration-none"><span>Home</span></a><br>
                        <a href="<?php echo e(url('about-us')); ?>" class="text-black text-decoration-none"><span>About
                                Us</span></a><br>
                        <a href="<?php echo e(url('blogs')); ?>"
                            class="text-black text-decoration-none"><span>Blogs</span></a><br>
                        <a href="<?php echo e(url('contact-us')); ?>" class="text-black text-decoration-none"><span>Contact
                                Us</span></a><br>
                        <a href="<?php echo e(url('brands')); ?>"
                            class="text-black text-decoration-none"><span>Brands</span></a><br>
                        <a href="<?php echo e(url('careers')); ?>"
                            class="text-black text-decoration-none"><span>Careers</span></a><br>
                    </div>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg">
                    <h3 class="fw-bold mb-5">Our Shop</h3>
                    <div class="lh-lg">
                        <a href="<?php echo e(url('shop-skin')); ?>" class="text-black text-decoration-none"><span>eg Skin
                                Essentials</span></a><br>
                        <a href="<?php echo e(url('shop-trends')); ?>" class="text-black text-decoration-none"><span>eg Trends
                                Apparel</span></a><br>
                    </div>
                </div>
                <div class="col-12 col-sm-12 col-md-12 col-lg-4">
                    <img src="<?php echo e(asset('resources/eg-weblogo1.png')); ?>" class="img-fluid mb-4" alt="">
                    <div class="lh-sm mb-4">
                        <span>Copyright © 2023 eg Trends Apparel.</span><br>
                        <span>Designed & Developed by <a href="https://rweb.solutions/" class="text-black">R Web
                                Solutions, Corp.</a></span>
                    </div>

                    <div class="hstack align-items-center gap-4">
                        <a href="https://www.facebook.com/EGTRENDSAPPAREL?mibextid=LQQJ4d"
                            class="text-decoration-none text-black" target="_blank"><span><i
                                    class="fa-brands fa-facebook-f"></i></span></a>
                        <a href="www.tiktok.com/@egtrendsapparel" class="text-decoration-none text-black"
                            target="_blank"><span><i class="fa-brands fa-tiktok"></i></span></a>
                        <a href="mailto:egtrendsapparel@gmail.com" class="text-decoration-none text-black"
                            target="_blank"><span><i class="fa-regular fa-envelope"></i></span></a>
                        <a href="https://www.instagram.com/egtrendsapparel_?igsh=NWNwdWhkYTBjY2gz"
                            class="text-decoration-none text-black" target="_blank"><span><i
                                    class="fa-brands fa-instagram"></i></span></a>
                        <a href="https://shope.ee/g3dE7iFkN" class="text-decoration-none pb-1">
                            <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="23" height="16"
                                viewBox="0 0 48 48">
                                <path
                                    d="M 24 1 C 19.015304 1 15.187203 5.491076 14.589844 11 L 5.0605469 11 C 4.4905469 11 4.0305469 11.480547 4.0605469 12.060547 L 5.7792969 41.230469 C 5.8992969 43.350469 7.6495312 45 9.7695312 45 L 38.230469 45 C 40.350469 45 42.100703 43.350469 42.220703 41.230469 L 43.939453 12.060547 C 43.969453 11.480547 43.509453 11 42.939453 11 L 33.410156 11 C 32.812797 5.491076 28.984696 1 24 1 z M 24 4 C 27.044271 4 29.834574 6.9017187 30.392578 11 L 17.607422 11 C 18.165426 6.9017187 20.955729 4 24 4 z M 24.080078 17.009766 C 27.000078 17.009766 29.300391 18.349922 30.150391 18.919922 L 30.320312 19.029297 C 30.540312 19.179297 30.610703 19.480937 30.470703 19.710938 L 29.460938 21.359375 C 29.380938 21.469375 29.270625 21.559844 29.140625 21.589844 C 29.100625 21.589844 29.069297 21.599609 29.029297 21.599609 C 28.929297 21.599609 28.83 21.569766 28.75 21.509766 L 28.609375 21.419922 C 28.419375 21.289922 28.059219 21.079766 27.949219 21.009766 C 27.219219 20.619766 25.740078 19.960938 24.080078 19.960938 C 21.780078 19.960938 20.109375 21.169844 20.109375 22.839844 C 20.109375 24.389844 21.499453 25.070391 24.439453 26.150391 C 27.479453 27.260391 31.259766 28.639062 31.259766 33.039062 C 31.259766 36.369063 28.039453 38.990234 23.939453 38.990234 C 20.459453 38.990234 17.629609 36.919297 16.849609 36.279297 L 16.730469 36.189453 C 16.530469 36.019453 16.490625 35.729531 16.640625 35.519531 L 17.740234 33.890625 C 17.820234 33.770625 17.949609 33.689922 18.099609 33.669922 L 18.150391 33.669922 C 18.280391 33.669922 18.400234 33.720781 18.490234 33.800781 L 18.619141 33.919922 C 18.639141 33.939922 21.109453 36.039063 23.939453 36.039062 C 26.349453 36.039062 28.310547 34.689062 28.310547 33.039062 C 28.310547 30.929063 26.749922 30.130156 23.419922 28.910156 C 20.639922 27.890156 17.169922 26.619844 17.169922 22.839844 C 17.169922 19.519844 20.140078 17.009766 24.080078 17.009766 z">
                                </path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-end">
                <button onclick="topFunction()" class="rounded-circle text-white btn-upward"><i
                        class="fa-solid fa-arrow-up-long"></i></button>
            </div>
        </div>
    </footer>

    <?php echo $__env->yieldContent('css'); ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-mobile/1.4.5/jquery.mobile.min.js"
        referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>

    <script>
        (function($) {
            'use strict';

            // Preloader JS
            $(window).on('load', function() {
                $(".preloader").fadeOut(500);
            });

        })(jQuery);

        let mybutton = document.getElementByClass('.btn-upward');

        window.onscroll = function() {
            scrollFunction()
        };

        function scrollFunction() {
            if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
                mybutton.style.display = "block";
            } else {
                mybutton.style.display = "none";
            }
        }


        function topFunction() {
            document.body.scrollTop = 0;
            document.documentElement.scrollTop = 0;
        }
    </script>
    <?php echo $__env->yieldContent('js'); ?>
</body>

</html>
<?php /**PATH D:\czed\EG APPAREL\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>