

<?php $__env->startSection('title', 'Careers / Create Career'); ?>

<?php $__env->startSection('admin-content'); ?>
<div class="flex justify-center items-center min-h-[85vh] bg-gray-50">
    <div class="w-full max-w-screen-2xl bg-white p-8 rounded-2xl shadow-lg border border-gray-100">
        <h1 class="text-3xl font-extrabold text-gray-800 mb-8 border-b pb-3">Create Career</h1>

        
        <?php if(session('success')): ?>
        <div class="mb-6 p-4 text-green-800 bg-green-100 border border-green-300 rounded-lg">
            <?php echo e(session('success')); ?>

        </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
        <div class="mb-6 p-4 text-red-800 bg-red-100 border border-red-300 rounded-lg">
            <?php echo e(session('error')); ?>

        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.careers.store')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?php echo csrf_field(); ?>

            
            <div>
                <label for="career_name" class="block text-sm font-semibold text-gray-700 mb-2">
                    Career Name <span class="text-red-500">*</span>
                </label>
                <input type="text" name="career_name" id="career_name"
                    class="block w-full border border-gray-300 rounded-lg px-4 py-2.5 focus:ring-2 focus:ring-[#FBD55B] focus:border-[#FBD55B]"
                    value="<?php echo e(old('career_name')); ?>" placeholder="Enter career name" required>
                <?php $__errorArgs = ['career_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div>
                <label for="job_type" class="block text-sm font-semibold text-gray-700 mb-2">
                    Job Type <span class="text-red-500">*</span>
                </label>
                <input type="text" name="job_type" id="job_type"
                    class="block w-full border border-gray-300 rounded-lg px-4 py-2.5 focus:ring-2 focus:ring-[#FBD55B] focus:border-[#FBD55B]"
                    value="<?php echo e(old('job_type')); ?>" placeholder="Enter job type" required>
                <?php $__errorArgs = ['job_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div>
                <label for="experience" class="block text-sm font-semibold text-gray-700 mb-2">Experience</label>
                <input type="text" name="experience" id="experience"
                    class="block w-full border border-gray-300 rounded-lg px-4 py-2.5 focus:ring-2 focus:ring-[#FBD55B] focus:border-[#FBD55B]"
                    value="<?php echo e(old('experience')); ?>" placeholder="Enter experience required">
                <?php $__errorArgs = ['experience'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div>
                <label for="vacancy" class="block text-sm font-semibold text-gray-700 mb-2">Vacancy</label>
                <input type="number" name="vacancy" id="vacancy"
                    class="block w-full border border-gray-300 rounded-lg px-4 py-2.5 focus:ring-2 focus:ring-[#FBD55B] focus:border-[#FBD55B]"
                    value="<?php echo e(old('vacancy')); ?>" placeholder="Number of vacancies">
                <?php $__errorArgs = ['vacancy'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div>
                <label for="overview" class="block text-sm font-semibold text-gray-700 mb-2">Overview</label>
                <textarea name="overview" id="overview" rows="5"
                    class="block w-full border border-gray-300 rounded-lg px-4 py-2.5 focus:ring-2 focus:ring-[#FBD55B] focus:border-[#FBD55B]"
                    placeholder="Describe this career"><?php echo e(old('overview')); ?></textarea>
                <?php $__errorArgs = ['overview'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Select Qualifications</label>
                <div id="qualifications-container" class="space-y-3">
                    <div class="flex gap-2">
                        <select name="qualification_ids[]" class="flex-1 border border-gray-300 rounded-lg px-4 py-2">
                            <option value="">-- Choose Qualification --</option>
                            <?php $__currentLoopData = $qualifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $qualification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($qualification->id); ?>"><?php echo e($qualification->qualification); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <button type="button" class="add-qualification px-3 py-2 bg-[#FBD55B] text-black font-semibold rounded-lg hover:bg-[#e4c14e] transition">+</button>
                    </div>
                </div>
            </div>

            
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">Select Responsibilities</label>
                <div id="responsibilities-container" class="space-y-3">
                    <div class="flex gap-2">
                        <select name="responsibility_ids[]" class="flex-1 border border-gray-300 rounded-lg px-4 py-2">
                            <option value="">-- Choose Responsibility --</option>
                            <?php $__currentLoopData = $responsibilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $responsibility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($responsibility->id); ?>"><?php echo e($responsibility->responsibility); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <button type="button" class="add-responsibility px-3 py-2 bg-[#FBD55B] text-black font-semibold rounded-lg hover:bg-[#e4c14e] transition">+</button>
                    </div>
                </div>
            </div>

            
            <div class="border-2 border-dashed rounded-xl p-8 text-center bg-gray-50 hover:bg-gray-100 transition relative">
                <p class="font-semibold text-gray-700">Upload Career Image</p>
                <p class="text-sm text-gray-500 mb-4">Accepted formats: JPG, PNG, WEBP — Max size: 2MB</p>
                <label for="career_image"
                    class="cursor-pointer inline-flex flex-col items-center bg-[#FBD55B] hover:bg-[#e4c14e] text-black font-semibold px-6 py-3 rounded-lg shadow transition">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M3 15a4 4 0 014-4h.586a1 1 0 01.707.293l2.414 2.414a1 1 0 001.414 0l2.414-2.414a1 1 0 01.707-.293H17a4 4 0 014 4v1a2 2 0 01-2 2H5a2 2 0 01-2-2v-1z" />
                    </svg>
                    <span>Select Image</span>
                    <input type="file" name="career_image" id="career_image" class="hidden" accept="image/*">
                </label>

                <div id="career_image_preview_container" class="hidden mt-4">
                    <p class="font-semibold mb-2">Career Image Preview:</p>
                    <div id="career_image_preview" class="relative inline-block rounded-lg overflow-hidden shadow-md"></div>
                </div>

                <?php $__errorArgs = ['career_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="text-red-600 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            
            <div class="flex justify-between items-center pt-4">
                <a href="<?php echo e(route('admin.careers.index')); ?>"
                    class="px-4 py-2 border rounded-lg bg-gray-100 hover:bg-gray-200 transition">← Back</a>
                <button type="submit"
                    class="px-6 py-2 bg-[#FBD55B] text-black font-semibold rounded-lg shadow hover:bg-[#e4c14e] transition">
                    Save Career
                </button>
            </div>
        </form>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        ClassicEditor.create(document.querySelector('#overview')).catch(console.error);

        // Qualifications add/remove
        const qualificationsContainer = document.getElementById('qualifications-container');
        qualificationsContainer.addEventListener('click', e => {
            if (e.target.matches('.add-qualification')) {
                const newRow = qualificationsContainer.firstElementChild.cloneNode(true);
                newRow.querySelector('select').value = '';
                const btn = newRow.querySelector('.add-qualification');
                btn.textContent = '−';
                btn.classList.remove('add-qualification', 'bg-[#FBD55B]');
                btn.classList.add('remove-qualification', 'bg-red-500', 'hover:bg-red-600');
                qualificationsContainer.appendChild(newRow);
            }
            if (e.target.matches('.remove-qualification')) {
                const row = e.target.closest('div.flex');
                if (qualificationsContainer.children.length > 1) row.remove();
            }
        });

        // Responsibilities add/remove
        const responsibilitiesContainer = document.getElementById('responsibilities-container');
        responsibilitiesContainer.addEventListener('click', e => {
            if (e.target.matches('.add-responsibility')) {
                const newRow = responsibilitiesContainer.firstElementChild.cloneNode(true);
                newRow.querySelector('select').value = '';
                const btn = newRow.querySelector('.add-responsibility');
                btn.textContent = '−';
                btn.classList.remove('add-responsibility', 'bg-[#FBD55B]');
                btn.classList.add('remove-responsibility', 'bg-red-500', 'hover:bg-red-600');
                responsibilitiesContainer.appendChild(newRow);
            }
            if (e.target.matches('.remove-responsibility')) {
                const row = e.target.closest('div.flex');
                if (responsibilitiesContainer.children.length > 1) row.remove();
            }
        });

        // Image preview
        const previewSetup = (inputId, previewId, containerId) => {
            const input = document.getElementById(inputId);
            const previewContainer = document.getElementById(containerId);
            const preview = document.getElementById(previewId);

            input.addEventListener('change', event => {
                const file = event.target.files[0];
                preview.innerHTML = '';
                if (!file) return;
                const reader = new FileReader();
                reader.onload = e => {
                    previewContainer.classList.remove('hidden');
                    preview.innerHTML = `<img src="${e.target.result}" class="w-full max-w-md h-auto rounded-lg shadow-lg object-cover">
                <button type="button" class="absolute -top-3 -right-3 bg-red-600 text-white rounded-full w-8 h-8 flex items-center justify-center shadow-md hover:bg-red-700 transition">✖</button>`;
                    preview.querySelector('button').onclick = () => {
                        input.value = '';
                        previewContainer.classList.add('hidden');
                    };
                };
                reader.readAsDataURL(file);
            });
        };

        previewSetup('career_image', 'career_image_preview', 'career_image_preview_container');
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\R Web\OneDrive\Documents\KEF\PRIME DOCTORS\resources\views/admin/careers/create.blade.php ENDPATH**/ ?>