

<?php $__env->startSection('title', 'Homepage Banner'); ?>

<?php $__env->startSection('admin-content'); ?>
<!-- Page Title -->
<h1 class="text-2xl font-semibold mb-6">HOMEPAGE BANNER</h1>

<!-- Top Bar -->
<div class="flex justify-between items-center mb-6">
    <!-- Create Button -->
    <a href="<?php echo e(route('admin.banners.create')); ?>"
        class="ml-auto inline-flex items-center gap-2 text-sm bg-gradient-to-r from-green-600 to-emerald-500 text-white px-6 py-3 rounded-xl shadow-md hover:shadow-lg hover:scale-105 transition-transform duration-200">

        <!-- Plus Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
            stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
        </svg>
        Create Banner
    </a>
</div>


<!-- Table -->
<div class="overflow-x-auto bg-white border rounded-lg shadow">
    <table id="users-table" class="min-w-full text-sm text-gray-700">
        <thead class="bg-black text-white">
            <tr>
                <th class="px-6 py-3 text-center w-20">ID</th>
                <th class="px-6 py-3 text-center w-1/5">Title</th>
                <th class="px-6 py-3 text-center w-1/5">Context</th>
                <th class="px-6 py-3 text-center w-1/5">Banner</th>
                <th class="px-6 py-3 text-center w-1/6">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr class="border-b hover:bg-gray-50">
                <td class="px-6 py-3 text-center"><?php echo e($banner->id); ?></td>
                <td class="px-6 py-3 text-center"><?php echo e($banner->title); ?></td>
                <td class="px-6 py-3 text-center"><?php echo e(strip_tags($banner->context)); ?></td>

                <td class="px-6 py-3 text-center">
                    <?php if($banner->image && $banner->image->file && $banner->image->file->image_path): ?>
                    <img src="<?php echo e(asset($banner->image->file->image_path)); ?>" alt="<?php echo e($banner->image->alt_text ?? 'Banner'); ?>"
                        class="mx-auto w-24 h-12 object-cover rounded shadow">
                    <?php else: ?>
                    <span class="text-gray-400 italic">No Image</span>
                    <?php endif; ?>
                </td>


                <td class="px-6 py-3 text-center">
                    <div class="flex justify-center items-center gap-2">
                        <a href="<?php echo e(route('admin.banners.edit', $banner->id)); ?>"
                            class="px-3 py-1 rounded text-white bg-blue-500 hover:bg-blue-600">Edit</a>
                        <form action="<?php echo e(route('admin.banners.destroy', $banner->id)); ?>" method="POST" class="inline delete-form">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="button" class="delete-btn px-3 py-1 rounded text-white bg-red-500 hover:bg-red-600">Delete</button>
                        </form>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    $(document).ready(function() {
        $('#users-table').DataTable({
            ordering: false
        });

        // ✅ SweetAlert Delete
        $(document).on('click', '.delete-btn', function(e) {
            e.preventDefault();
            let form = $(this).closest('form');

            Swal.fire({
                title: "Are you sure?",
                text: "This banner will be permanently deleted.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#d33",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>

<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "<?php echo e(session('success')); ?>",
        timer: 2000,
        showConfirmButton: false
    });
</script>
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\R Web\OneDrive\Documents\KEF\PRIME DOCTORS\resources\views/admin/banners/index.blade.php ENDPATH**/ ?>