

<?php $__env->startSection('title', 'Edit Banner'); ?>

<?php $__env->startSection('admin-content'); ?>
<!-- Page Title -->
<h1 class="text-2xl font-semibold mb-6">EDIT HOMEPAGE BANNER</h1>

<!-- Back Button -->
<div class="flex justify-between items-center mb-6">
    <a href="<?php echo e(route('admin.banners.index')); ?>"
        class="inline-flex items-center gap-2 text-sm bg-black text-white px-5 py-2 rounded-xl shadow-md hover:bg-gray-600 transition duration-200">
        <!-- Arrow Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
            stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
        </svg>
        Back
    </a>
</div>

<!-- Edit Form -->
<div class="bg-white rounded-xl shadow-md p-8 border border-gray-200 max-w-3xl mx-auto">
    <form action="<?php echo e(route('admin.banners.update', $banner->id)); ?>" method="POST" enctype="multipart/form-data"
        class="space-y-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Title -->
        <div>
            <label class="block font-semibold mb-2">Title <span class="text-red-500">*</span></label>
            <input type="text" name="title" value="<?php echo e(old('title', $banner->title)); ?>"
                class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-400 focus:outline-none"
                placeholder="Enter banner title" required>
            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- Context -->
        <div>
            <label class="block font-semibold mb-2">Context</label>
            <textarea name="context" rows="4"
                class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-400 focus:outline-none"
                placeholder="Enter short description or banner text"><?php echo e(old('context', strip_tags($banner->context))); ?></textarea>
            <?php $__errorArgs = ['context'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>



        <!-- Location -->
        <div>
            <label class="block font-semibold mb-2">Location</label>
            <input type="text" name="location" value="<?php echo e(old('location', $banner->location ?? '')); ?>"
                class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-400 focus:outline-none"
                placeholder="Homepage / About Page / etc.">
            <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- Link -->
        <div>
            <label class="block font-semibold mb-2">Link</label>
            <input type="text" name="link" value="<?php echo e(old('link', $banner->link)); ?>"
                class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-400 focus:outline-none"
                placeholder="Optional external or internal link">
            <?php $__errorArgs = ['link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- Current Image Preview -->
        <div>
            <label class="block font-semibold mb-2">Current Banner</label>
            <?php if($banner->image && $banner->image->file && $banner->image->file->image_path): ?>
            <img src="<?php echo e(asset($banner->image->file->image_path)); ?>"
                alt="<?php echo e($banner->image->alt_text ?? 'Banner'); ?>"
                class="w-56 h-28 object-cover rounded shadow border mb-3">
            <?php else: ?>
            <p class="text-gray-400 italic">No image uploaded.</p>
            <?php endif; ?>
        </div>

        <!-- Upload New Image -->
        <div>
            <label class="block font-semibold mb-2">Upload New Image (optional)</label>
            <input type="file" name="image"
                class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-green-400 focus:outline-none
                       file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm
                       file:bg-green-600 file:text-white hover:file:bg-green-700">
            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="text-red-500 text-xs mt-1"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- Save Button -->
        <div class="pt-4">
            <button type="submit"
                class="w-full bg-gradient-to-r from-green-600 to-emerald-500 text-white py-3 rounded-xl font-semibold shadow-md hover:shadow-lg hover:scale-[1.02] transition duration-200">
                Save Changes
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "<?php echo e(session('success')); ?>",
        timer: 2000,
        showConfirmButton: false
    });
</script>
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\R Web\OneDrive\Documents\KEF\PRIME DOCTORS\resources\views/admin/banners/edit.blade.php ENDPATH**/ ?>