<?php $__env->startSection('title', 'Careers'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex flex-col">
    <?php if (isset($component)) { $__componentOriginalff9615640ecc9fe720b9f7641382872b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff9615640ecc9fe720b9f7641382872b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.banner','data' => ['title1' => 'Career','title2' => 'Opportunities','imgPath' => 'assets/careers-banner.png','page' => 'Careers /','breadcrumb' => ''.e($career->title).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('banner'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title1' => 'Career','title2' => 'Opportunities','img_path' => 'assets/careers-banner.png','page' => 'Careers /','breadcrumb' => ''.e($career->title).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff9615640ecc9fe720b9f7641382872b)): ?>
<?php $attributes = $__attributesOriginalff9615640ecc9fe720b9f7641382872b; ?>
<?php unset($__attributesOriginalff9615640ecc9fe720b9f7641382872b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff9615640ecc9fe720b9f7641382872b)): ?>
<?php $component = $__componentOriginalff9615640ecc9fe720b9f7641382872b; ?>
<?php unset($__componentOriginalff9615640ecc9fe720b9f7641382872b); ?>
<?php endif; ?>

    <div class="bg-gray-100">
        <div class="grid h-full grid-cols-1 py-24">
            <div class="container grid grid-cols-1 mx-auto lg:flex">
                <div class=" w-[66%] ">
                    <img src="<?php echo e(asset($career->image?->file?->image_path ?? 'assets/default-career.jpg')); ?>"
                        alt="<?php echo e($career->image?->alt_text ?? $career->title); ?>"
                        class="object-cover w-full h-[28rem] rounded-3xl shadow-md">
                </div>
                <div class="flex flex-col items-start justify-between w-1/3 p-10 ">
                    <a href="<?php echo e(route('careers')); ?>" class="flex items-center gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                            class="text-[#0035c6]">
                            <rect width="24" height="24" fill="none" />
                            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                stroke-width="2" d="m9 11l-4 4l4 4m-4-4h11a4 4 0 0 0 0-8h-1" />
                        </svg>
                        <div class="text-[#0035c6]">
                            Back to Careers
                        </div>
                    </a>
                    <div class="flex flex-col gap-3">
                        <div>
                            <span
                                class="<?php echo e($career->job_type === 'Part-time' ? 'bg-yellow-500 text-black' : 'bg-blue-600 text-white'); ?> px-2 py-1 text-md font-medium rounded">
                                <?php echo e($career->job_type); ?>

                            </span>
                        </div>
                        <div class="text-4xl font-medium">
                            <?php echo e($career->title); ?>

                        </div>
                        <div class="flex items-center gap-2">
                            <div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15"
                                    viewBox="0 0 24 22" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="lucide lucide-clock-icon lucide-clock">
                                    <path d="M12 6v6l4 2" />
                                    <circle cx="12" cy="12" r="10" />
                                </svg>
                            </div>
                            <div>
                                <p class="text-lg text-gray-500">
                                    Posted <span><?php echo e($career->monthsAgo); ?></span> months ago
                                </p>
                            </div>
                        </div>
                        <div class="w-fit">
                            <a href="#"
                                class="flex items-center gap-5 px-1 py-1 text-white transition duration-300 rounded-full shadow bg-[#0035c6] hover:scale-105 hover:shadow-lg">
                                <span class="ml-5 mr-5 text-base font-semibold text-nowrap">APPLY NOW</span>
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 lg:h-14">
                                    <g fill="none" stroke="currentColor" stroke-width="1">
                                        <circle cx="12" cy="12" r="10" />
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M8 12h8m0 0l-3-3m3 3l-3 3" />
                                    </g>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div>
                <div class="container grid grid-cols-1 gap-8 px-4 py-10 mx-auto lg:grid-cols-3">
                    <!-- LEFT CONTENT -->
                    <div class="col-span-2 space-y-8">
                        <!-- Employment Info -->
                        <div class="p-6 bg-white shadow rounded-xl">
                            <div class="pb-3 text-xl font-semibold border-b pattaya-regular">Employment Info</div>
                            <div class="grid grid-cols-3 pt-3 space-y-3">
                                <section class="flex items-center col-span-1 gap-3">
                                    <img src="<?php echo e(asset('assets/career-icon1.png')); ?>" alt="" class="w-auto h-4">
                                    <div class="text-base text-gray-500">Vacancy</div>
                                </section>
                                <section class="col-span-2 text-lg">
                                    <?php echo e($career->vacancy); ?>

                                </section>

                                <section class="flex items-center col-span-1 gap-3">
                                    <img src="<?php echo e(asset('assets/career-icon2.png')); ?>" alt="" class="w-auto h-4">
                                    <div class="text-base text-gray-500">Job Type</div>
                                </section>
                                <section class="col-span-2 text-lg">
                                    <?php echo e($career->job_type); ?>

                                </section>

                                <section class="flex items-center col-span-1 gap-3">
                                    <img src="<?php echo e(asset('assets/career-icon3.png')); ?>" alt=""
                                        class="w-auto h-4">
                                    <div class="text-base text-gray-500">Experience</div>
                                </section>
                                <section class="col-span-2 text-lg">
                                    <?php echo e($career->experience); ?>

                                </section>

                                <section class="flex items-center col-span-1 gap-3">
                                    <img src="<?php echo e(asset('assets/career-icon4.png')); ?>" alt=""
                                        class="w-auto h-4">
                                    <div class="text-base text-gray-500">Posted</div>
                                </section>
                                <section class="col-span-2 text-lg">
                                    <span><?php echo e($career->monthsAgo); ?></span> months ago
                                </section>

                                <section class="flex items-center col-span-1 gap-3">
                                    <img src="<?php echo e(asset('assets/career-icon5.png')); ?>" alt=""
                                        class="w-auto h-4">
                                    <div class="text-base text-gray-500">Date Updated</div>
                                </section>
                                <section class="col-span-2 text-lg">
                                    <?php echo e(\Carbon\Carbon::parse($career->date_updated)->format('M d, Y')); ?>

                                </section>
                            </div>
                        </div>

                        <!-- Overview -->
                        <div>
                            <div class="mb-3 text-3xl font-bold pattaya-regular">Overview</div>
                            <p class="text-gray-700">
                                <?php echo $career->overview; ?>

                            </p>
                        </div>

                        <!-- Key Responsibilities -->
                        <div>
                            <div class="mb-3 text-3xl font-bold pattaya-regular">Key Responsibilities</div>
                            <ul class="space-y-2 text-gray-700">
                                <?php $__currentLoopData = $career->responsibilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-center gap-3">
                                    <img src="<?php echo e(asset('assets/career-icon9.png')); ?>" alt=""
                                        class="w-auto h-4">
                                    <li class="flex items-start">
                                        <?php echo e($item->responsibility); ?>

                                    </li>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>

                        <!-- Qualifications -->
                        <div>
                            <div class="mb-3 text-3xl font-bold pattaya-regular">Qualifications</div>
                            <ul class="space-y-2 text-gray-700">
                                <?php $__currentLoopData = $career->qualifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="flex items-start">
                                    <span class="mr-2 text-yellow-500">✔</span>
                                    <?php echo e($item->qualification); ?>

                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>


                        <!-- Apply + Share -->
                        <div class="flex items-center justify-between">
                            <div class="w-fit">
                                <a href="#"
                                    class="flex items-center gap-5 px-1 py-1 text-white transition duration-300 rounded-full shadow bg-[#0035c6] hover:scale-105 hover:shadow-lg">
                                    <span class="ml-5 mr-5 text-base font-semibold text-nowrap">APPLY NOW</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="h-7 lg:h-14">
                                        <g fill="none" stroke="currentColor" stroke-width="1">
                                            <circle cx="12" cy="12" r="10" />
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M8 12h8m0 0l-3-3m3 3l-3 3" />
                                        </g>
                                    </svg>
                                </a>
                            </div>
                            <div class="flex items-center space-x-3">
                                <span class="text-gray-600">Share:</span>
                                <a href="#" class="transition duration-300 cursor pointer hover:scale-105">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="-2 -2 24 24"
                                        class="h-10 p-1 border-[6px] rounded-full border-[#edb42f] text-[#edb42f]">
                                        <path fill="currentColor"
                                            d="M13.397 20.997v-8.196h2.765l.411-3.209h-3.176V7.548c0-.926.258-1.56 1.587-1.56h1.684V3.127A22 22 0 0 0 14.201 3c-2.444 0-4.122 1.492-4.122 4.231v2.355H7.332v3.209h2.753v8.202z" />
                                    </svg>
                                </a>
                                <a href="#" class="transition duration-300 cursor pointer hover:scale-105">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="-0 -0 24 24"
                                        class="h-10 p-1 border-[6px] rounded-full border-[#edb42f] text-[#edb42f]">
                                        <path fill="currentColor"
                                            d="M7.8 2h8.4C19.4 2 22 4.6 22 7.8v8.4a5.8 5.8 0 0 1-5.8 5.8H7.8C4.6 22 2 19.4 2 16.2V7.8A5.8 5.8 0 0 1 7.8 2m-.2 2A3.6 3.6 0 0 0 4 7.6v8.8C4 18.39 5.61 20 7.6 20h8.8a3.6 3.6 0 0 0 3.6-3.6V7.6C20 5.61 18.39 4 16.4 4zm9.65 1.5a1.25 1.25 0 0 1 1.25 1.25A1.25 1.25 0 0 1 17.25 8A1.25 1.25 0 0 1 16 6.75a1.25 1.25 0 0 1 1.25-1.25M12 7a5 5 0 0 1 5 5a5 5 0 0 1-5 5a5 5 0 0 1-5-5a5 5 0 0 1 5-5m0 2a3 3 0 0 0-3 3a3 3 0 0 0 3 3a3 3 0 0 0 3-3a3 3 0 0 0-3-3" />
                                    </svg>
                                </a>
                                <a href="#" class="transition duration-300 cursor pointer hover:scale-105">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="-0 -0 25 25"
                                        class="h-10 p-1 border-[6px] rounded-full border-[#edb42f] text-[#edb42f]">
                                        <rect width="24" height="24" fill="none" />
                                        <path fill="currentColor"
                                            d="M6.94 5a2 2 0 1 1-4-.002a2 2 0 0 1 4 .002M7 8.48H3V21h4zm6.32 0H9.34V21h3.94v-6.57c0-3.66 4.77-4 4.77 0V21H22v-7.93c0-6.17-7.06-5.94-8.72-2.91z"
                                            stroke-width="0.5" stroke="currentColor" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- RIGHT SIDEBAR -->
                    <div class="space-y-6">
                        <!-- Map + Contact -->
                        <div class="overflow-hidden rounded-2xl">
                            <div class="p-5 text-white bg-blue-600">
                                Other Careers
                            </div>
                            <div class="flex flex-col gap-5 p-5 bg-white shadow">
                                <iframe class="w-full h-40 border rounded border-[#edb42f]"
                                    src="https://maps.google.com/maps?q=Antipolo&t=&z=13&ie=UTF8&iwloc=&output=embed"></iframe>
                                <div class="mt-3 space-y-5 text-sm text-gray-700">
                                    <div class="flex items-center gap-2">
                                        <img src="<?php echo e(asset('assets/career-icon6.png')); ?>" alt="">
                                        <div>
                                            Antipolo del Sur 4217 Lipa City, Philippines
                                        </div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <img src="<?php echo e(asset('assets/career-icon7.png')); ?>" alt="">
                                        <div>
                                            0917 327 7463
                                        </div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <img src="<?php echo e(asset('assets/career-icon8.png')); ?>" alt="">
                                        <div>
                                            primedoctorsmedicalcenter@gmail.com
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Other Careers -->
                        <div class="overflow-hidden rounded-2xl">
                            <div class="p-5 text-white bg-blue-600">Other Careers</div>
                            <div>
                                <div
                                    class="flex flex-col gap-5 p-5 bg-white divide-y shadow h-[34rem] overflow-y-scroll">
                                    <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('careers.show', ['id' => $item->id])); ?>"
                                        class="flex items-center p-3 space-x-3 transition duration-300 hover:bg-blue-600/10">
                                        <div class="h-auto overflow-hidden rounded-md w-44">
                                            <img src="<?php echo e(asset($item->image?->file?->image_path ?? 'assets/default-career.jpg')); ?>"
                                                alt="<?php echo e($item->image?->alt_text ?? $item->title); ?>"
                                                class="object-cover w-full h-32 rounded-md">

                                        </div>
                                        <div class="flex flex-col w-full gap-3">
                                            <div>
                                                <div class="font-semibold"><?php echo e($item->title); ?></div>
                                                <p class="text-sm text-gray-500">Posted
                                                    <span><?php echo e($item->monthsAgo); ?></span> months ago
                                                </p>
                                            </div>
                                            <div class="flex justify-between">
                                                <div class="flex items-center gap-2 text-sm text-gray-700">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="17"
                                                        height="17" viewBox="0 0 20 20">
                                                        <rect width="20" height="20" fill="none" />
                                                        <path fill="currentColor"
                                                            d="M7 8a3 3 0 1 0 0-6a3 3 0 0 0 0 6m7.5 1a2.5 2.5 0 1 0 0-5a2.5 2.5 0 0 0 0 5M1.615 16.428a1.22 1.22 0 0 1-.569-1.175a6.002 6.002 0 0 1 11.908 0c.058.467-.172.92-.57 1.174A9.95 9.95 0 0 1 7 18a9.95 9.95 0 0 1-5.385-1.572M14.5 16h-.106c.07-.297.088-.611.048-.933a7.47 7.47 0 0 0-1.588-3.755a4.5 4.5 0 0 1 5.874 2.636a.82.82 0 0 1-.36.98A7.47 7.47 0 0 1 14.5 16"
                                                            stroke-width="0.5" stroke="currentColor" />
                                                    </svg>
                                                    <span>
                                                        <?php echo e($item->vacancy); ?>

                                                        <?php echo e($item->vacancy > 1 ? ' vacancies' : ' vacancy'); ?>

                                                    </span>
                                                </div>
                                                <div
                                                    class="<?php echo e($item->type === 'Part-time' ? 'text-black bg-yellow-500' : 'text-white bg-blue-600'); ?>  inline-block px-2 py-1 mt-1 text-xs rounded">
                                                    <?php echo e($item->type); ?>

                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\R Web\OneDrive\Documents\KEF\PRIME DOCTORS\resources\views/pages/show_career.blade.php ENDPATH**/ ?>