

<?php $__env->startSection('title', 'Services'); ?>

<?php $__env->startSection('admin-content'); ?>
<!-- Page Title -->
<h1 class="text-2xl font-semibold mb-6">SERVICES</h1>

<!-- Top Bar -->
<div class="flex justify-between items-center mb-6">
    <!-- Create Button -->
    <a href="<?php echo e(route('admin.services.create')); ?>"
        class="ml-auto inline-flex items-center gap-2 text-sm bg-gradient-to-r from-green-600 to-emerald-500 text-white px-6 py-3 rounded-xl shadow-md hover:shadow-lg hover:scale-105 transition-transform duration-200">

        <!-- Plus Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
            stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
        </svg>

        Create Service
    </a>
</div>

<!-- Table -->
<div class="overflow-x-auto bg-white border rounded-lg">
    <table id="services-table" class="table-fixed w-full border-collapse">
        <thead>
            <tr class="bg-black text-white text-sm font-semibold">
                <th class="px-10 py-3 rounded-tl-lg text-center w-16">ID</th>
                <th class="px-10 py-3 w-1/4 text-center">Title</th>
                <th class="px-10 py-3 w-1/4 text-center">Description</th>
                <th class="px-10 py-3 w-1/4 text-center">Why It Matters</th>
                <th class="px-10 py-3 text-center w-1/4">Benefits</th>
                <th class="px-10 py-3 text-center w-1/4">Inclusions</th>
                <th class="px-10 py-3 text-center w-1/4">Icon</th>
                <th class="px-10 py-3 text-center w-1/4">Image</th>
                <th class="px-10 py-3 rounded-tr-lg text-center whitespace-nowrap w-40">Actions</th>
            </tr>
        </thead>

        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr class="border-t">
                <td class="px-10 py-3 text-center"><?php echo e($service->id); ?></td>
                <td class="px-10 py-3 text-center"><?php echo e($service->title); ?></td>
                <td class="px-10 py-3 text-center"><?php echo Str::limit(strip_tags($service->description), 80); ?></td>
                <td class="px-10 py-3 text-center"><?php echo Str::limit(strip_tags($service->why_it_matters), 80); ?></td>

                <td class="px-10 py-3 text-center">
                    <?php if($service->benefits->isNotEmpty()): ?>
                    <ul class="list-disc list-inside">
                        <?php $__currentLoopData = $service->benefits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $benefit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($benefit->benefit_name); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <?php else: ?>
                    <span class="text-gray-400 italic">None</span>
                    <?php endif; ?>
                </td>

                <td class="px-10 py-3 text-center">
                    <?php if($service->inclusions->isNotEmpty()): ?>
                    <ul class="list-disc list-inside">
                        <?php $__currentLoopData = $service->inclusions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inclusion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($inclusion->inclusion_name); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <?php else: ?>
                    <span class="text-gray-400 italic">None</span>
                    <?php endif; ?>
                </td>


                
                <td class="px-10 py-3 text-center">
                    <?php if($service->icon_image_id && $service->icon && $service->icon->file): ?>
                    <img src="<?php echo e(asset('storage/' . $service->icon->file->image_path)); ?>"
                        alt="<?php echo e($service->title); ?> Icon"
                        class="h-12 w-12 object-contain rounded shadow mx-auto">
                    <?php elseif(isset($service->icon_image_id)): ?>
                    
                    <img src="<?php echo e(asset('storage/services/icons/' . basename(optional($service->icon)?->file?->image_path ?? ''))); ?>"
                        alt="<?php echo e($service->title); ?> Icon"
                        class="h-12 w-12 object-contain rounded shadow mx-auto">
                    <?php else: ?>
                    <span class="text-gray-400 italic">No Icon</span>
                    <?php endif; ?>
                </td>

                
                <td class="px-10 py-3 text-center">
                    <?php if($service->service_image_id && $service->image && $service->image->file): ?>
                    <img src="<?php echo e(asset('storage/' . $service->image->file->image_path)); ?>"
                        alt="<?php echo e($service->title); ?> Image"
                        class="h-12 w-20 object-cover rounded shadow mx-auto">
                    <?php elseif(isset($service->service_image_id)): ?>
                    
                    <img src="<?php echo e(asset('storage/services/' . basename(optional($service->image)?->file?->image_path ?? ''))); ?>"
                        alt="<?php echo e($service->title); ?> Image"
                        class="h-12 w-20 object-cover rounded shadow mx-auto">
                    <?php else: ?>
                    <span class="text-gray-400 italic">No Image</span>
                    <?php endif; ?>
                </td>

                
                <td class="px-6 py-3 whitespace-nowrap">
                    <div class="flex justify-center items-center gap-2">
                        <a href="<?php echo e(route('admin.services.edit', $service->id)); ?>"
                            class="px-3 py-1 rounded text-white bg-blue-500 hover:bg-blue-600">
                            Edit
                        </a>

                        <button type="button"
                            onclick="confirmDelete(<?php echo e($service->id); ?>)"
                            class="px-3 py-1 rounded text-white bg-red-500 hover:bg-red-600">
                            Delete
                        </button>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // ✅ Initialize DataTable
    $(document).ready(function() {
        $('#services-table').DataTable({
            ordering: false,
            pageLength: 10,
            language: {
                search: "_INPUT_",
                searchPlaceholder: "Search services..."
            }
        });
    });

    // ✅ SweetAlert Delete Confirmation
    function confirmDelete(serviceId) {
        Swal.fire({
            title: 'Are you sure?',
            text: "Delete this service? This action cannot be undone.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#EF4444',
            cancelButtonColor: '#6B7280',
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                let form = document.createElement('form');
                form.method = 'POST';
                form.action = "/admin/services/" + serviceId;

                let csrf = document.createElement('input');
                csrf.type = 'hidden';
                csrf.name = '_token';
                csrf.value = "<?php echo e(csrf_token()); ?>";

                let method = document.createElement('input');
                method.type = 'hidden';
                method.name = '_method';
                method.value = 'DELETE';

                form.appendChild(csrf);
                form.appendChild(method);
                document.body.appendChild(form);
                form.submit();
            }
        });
    }
</script>


<?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Success!',
        text: "<?php echo e(session('success')); ?>",
        timer: 2000,
        showConfirmButton: false
    });
</script>
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.adminapp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\R Web\OneDrive\Documents\KEF\PRIME DOCTORS\resources\views/admin/services/index.blade.php ENDPATH**/ ?>