<?php

namespace App\Http\Controllers\Admin\Page\Blogs;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Blog;
use Validator;
use Str;

class BlogController extends Controller
{
    
    public function index()
    {
        $data = Blog::latest()->get();
        return view('module.blogs.blog.index', compact('data'));
    }

    
    public function create()
    {
        return view('module.blogs.blog.create');
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'tag_id' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:1048',
            'blog_date' => 'required',
            'description' => 'required',
            'client' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        if($request->image){
            $path = public_path().'/uploads/blogs';
            $img = str_replace(' ', '_', $request->title).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $request->image = $img;

        }

        Blog::create([
            'title' => $request->title,
            'tag_id' => json_encode($request->tag_id),
            'image' => $request->image,
            'blog_date' => $request->blog_date,
            'description' => $request->description,
            'client' => $request->client,
        ]);

        return redirect('Admin/Blogs')->with('success', 'Successfully added new tag');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        $data = Blog::findOrFail($id);
        return view('module.blogs.blog.update', compact('data'));
    }

    
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'tag_id' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:1048',
            'blog_date' => 'required',
            'description' => 'required',
            'client' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        $blog = Blog::findOrFail($id);
        $blog->title = $request->title;
        $blog->tag_id = json_encode($request->tag_id);
        $blog->blog_date = $request->blog_date;
        $blog->description = $request->description;
        $blog->client = $request->client;

        if($request->image){
            $path = public_path().'/uploads/blogs';
            $img = str_replace(' ', '_', $request->title).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $blog->image = $img;
        }

        $data = Blog::findOrFail($id);
        $blog->save();

        if($request->image and $data->image){
            $path = public_path().'/uploads/blogs/';
            unlink($path.$data->image);
        }
        return redirect('Admin/Blogs')->with('success', 'Successfully updated tag');
    }

    
    public function destroy($id)
    {
        $data = Blog::findOrFail($id);
        $data->delete();

        if($data->image){
            $path = public_path().'/uploads/blogs/';
            unlink($path.$data->image);
        }
        return redirect('Admin/Blogs')->with('success', 'Successfully deleted tag');
    }
}
