<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use App\Models\Page\Comment;
use Illuminate\Http\Request;
use Validator;

class CommentController extends Controller
{
    
    public function index()
    {
        $data = Comment::latest()->get();
        return view('module.comment.index', compact('data'));
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
            'message' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        Comment::create([
            'blog_id' => $request->blog_id,
            'news_id' => $request->news_id,
            'event_id' => $request->event_id,
            'name' => $request->name,
            'email' => $request->email,
            'message' => $request->message,
        ]);

        return back()->with('message', 'Your comment have been sent. Thank you for your feedback!');
    }
    
    public function destroy($id)
    {
        Comment::findOrFail($id)->delete();

        return back()->with('success', 'Sucessfully deleted comment');
    }
}
