<?php

namespace App\Http\Controllers\Admin\Page\Events;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Events\Event;
use Validator;
use Str;

class EventController extends Controller
{
    public function index()
    {
        $data = Event::latest()->get();
        return view('module.events.event.index', compact('data'));
    }

    
    public function create()
    {
        return view('module.events.event.create');
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'tag_id' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:1048',
            'description' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        if($request->image){
            $path = public_path().'/uploads/events';
            $img = str_replace(' ', '_', $request->title).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $request->image = $img;

        }

        Event::create([
            'title' => $request->title,
            'tag_id' => json_encode($request->tag_id),
            'image' => $request->image,
            'description' => $request->description,
        ]);

        return redirect('Admin/Events')->with('success', 'Successfully added new events');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        $data = Event::findOrFail($id);
        return view('module.events.event.update', compact('data'));
    }

    
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'tag_id' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:1048',
            'description' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        $events = Event::findOrFail($id);
        $events->title = $request->title;
        $events->tag_id = json_encode($request->tag_id);
        $events->description = $request->description;

        if($request->image){
            $path = public_path().'/uploads/events';
            $img = str_replace(' ', '_', $request->title).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $events->image = $img;
        }

        $data = Event::findOrFail($id);
        $events->save();

        if($request->image and $data->image){
            $path = public_path().'/uploads/events/';
            unlink($path.$data->image);
        }
        return redirect('Admin/Events')->with('success', 'Successfully updated event');
    }

    
    public function destroy($id)
    {
        $data = Event::findOrFail($id);
        $data->delete();

        if($data->image){
            $path = public_path().'/uploads/events/';
            unlink($path.$data->image);
        }
        return redirect('Admin/Events')->with('success', 'Successfully deleted event');
    }
}
