<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Partner;
use Validator;
use Str;

class PartnerController extends Controller
{
    
    public function index()
    {
        $data = Partner::latest()->get();
        return view('module.partner.index', compact('data'));
    }

    
    public function create()
    {
        //
    }

   
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:1048',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        if($request->image){
            $path = public_path().'/uploads/partner';
            $img = str_replace(' ', '_', $request->name).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $request->image = $img;

        }

        Partner::create([
            'name' => $request->name,
            'image' => $request->image,
            'description' => $request->description,
        ]);

        return redirect('Admin/Partners')->with('success', 'Successfully added new partner');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        //
    }

    
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:1048',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        $partner = Partner::findOrFail($id);
        $partner->name = $request->name;
        $partner->description = $request->description;

        if($request->image){
            $path = public_path().'/uploads/partner';
            $img = str_replace(' ', '_', $request->name).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $partner->image = $img;
        }

        $data = Partner::findOrFail($id);
        $partner->save();

        if($request->image and $data->image){
            $path = public_path().'/uploads/partner/';
            unlink($path.$data->image);
        }

        return back()->with('success', 'Successfully updated partner');

    }

    
    public function destroy($id)
    {
        $data = Partner::findOrFail($id);
        $data->delete();

        if($data->image){
            $path = public_path().'/uploads/partner/';
            unlink($path.$data->image);
        }

        return back()->with('success', 'Successfully deleted partner');
    }
}
