<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Product;
use Validator;
use Str;

class ProductController extends Controller
{


    public function index()
    {
        $data = Product::latest()->get();
        return view('module.product.index', compact('data'));
    }


    public function create()
    {
        return view('module.product.create');
    }


    public function store(Request $request)
    {
        
        // return $request;
        $images_name = [];
        if($request->hasFile('image')){
            
            $allowedfileExtension = ['jpg','png','jpeg'];
            $files = $request->image;

            $min = 6;
            // return count($files);

            if(count($files) > $min){
                return back()->with('error', 'Upload error '.$min.' Images are allowed');
            } 
            
            foreach($files as $file){
                $filename = $file->getClientOriginalName();
                $extension = $file->getClientOriginalExtension();
                $check = in_array($extension,$allowedfileExtension);

                if($check){
                    array_push($images_name, $this->uploadFile('/uploads/products/thumbnail', $file));
                }
            }
        }

        Product::create([
            'price' => $request->price,
            'name' => $request->name,
            'image' => json_encode($images_name),
            'category' => $request->category,
            'description' => $request->description,
        ]);

        return back()->with('success', 'Successfully added new product');
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $data = Product::findOrFail($id);
        return view('module.product.update', compact('data'));
    }


    public function update(Request $request, $id)
    {

        $product = Product::findOrFail($id);
        $product->price = $request->price;
        $product->name = $request->name;
        $product->category = $request->category;
        $product->active = $request->active;
        $product->description = $request->description;

        $images_name = [];
        if($request->hasFile('image')){
            
            $data = Product::findOrFail($id);
            if($data->image){
                $path = public_path().'/uploads/products/thumbnail/';
                foreach (json_decode($data->image) as $key => $value) {
                    unlink($path.$value);
                }
            }

            // $allowedfileExtension = ['jpg','png','jpeg'];
            $files = $request->image;

            $min = 6;

            if(count($files) > $min){
                return back()->with('error', 'Upload error '.$min.' Images are allowed');
            } 
            
            foreach($files as $file){

                $filename = $file->getClientOriginalName();
                $extension = $file->getClientOriginalExtension();
                // $check = in_array($extension,$allowedfileExtension);

                // if($check){
                    array_push($images_name, $this->uploadFile('/uploads/products/thumbnail', $file));
                // }
            }

            $product->image = json_encode($images_name);

        }

        $product->save();

        return back()->with('success', 'Successfully updated product');
    }


    public function destroy($id)
    {
        // return $id;
        $data = Product::findOrFail($id);
        $data->delete();
        
        if($data->image){
            $path = public_path().'/uploads/products/thumbnail/';
            foreach (json_decode($data->image) as $key => $value) {
                unlink($path.$value);
            }
        }

        return back()->with('success', 'Successfully deleted product');
    }

    public function uploadFile($path, $file){
        $path = public_path().$path;
        $filename = date_format(date_create(), 'mdyHis').Str::random(5).'.'. $file->getClientOriginalExtension();
        $file->move($path, $filename);
        return $filename;
    }
}
