<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{

    public function login()
    {
        if (Auth::check()) {
            if (Auth::user()->role === 'Customer') {
                return redirect('/user/dashboard');
            }
            if (Auth::user()->role === 'Admin') {
                return redirect('/admin/dashboard');
            }
        }
        return view('layouts.admin.auth.login');
    }

    public function signin(Request $request)
    {
        // return $request;
        $request->validate([
            'email' => 'required|exists:users,email',
            'password' => 'required'
        ]);


        $credentials = $request->only('email', 'password');
        // return Auth::attempt($credentials);
        if (Auth::attempt($credentials)) {
            // return Auth::user()->role;
            if (Auth::user()->role === 'Admin') {
                return redirect('/admin/dashboard')->with('success', 'Successfully Login.');
            }
            Auth::logout();
            return redirect('/admin/login')->withErrors(['email' => 'Invalid account.']);
        }

        return redirect('/admin/login')->with('warning', 'Invalid!');
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect('/admin/login')->with('success', 'Successfully Logout.');
    }
}
