<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CalculationController extends Controller
{
    public $price;
    public $quantity;
    public $discount_value;

    public function __construct($price, $quantity = 0, $discount_value = 0)
    {
        $this->price = floatval($price);
        $this->quantity = intval($quantity);
        $this->discount_value = floatval($discount_value);
    }
    public function total()
    {
        $total = $this->price * $this->quantity;
        $discounted = $total * $this->discount_value;
        $subtotal = $total - $discounted;
        return number_format($subtotal,2);
    }
}
