<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\Order;
use App\Models\Product;
use Illuminate\Http\Request;
use Spatie\Searchable\Search;
use App\Models\Project;
use App\Models\Client;
use Auth;

class PageController extends Controller
{
    public function home(){
    	return view('front.home');
    }

    public function aboutQuanta(){
        return view('front.our-company.about-quanta');
    }
    public function historyQuanta(){
        return view('front.our-company.history-quanta');
    }
    public function leadershipQuanta(){
        return view('front.our-company.leadership-quanta');
    }
    public function makingDifferenceQuanta(){
        return view('front.our-company.making-difference-quanta');
    }
    public function visionMissionQuanta(){
        return view('front.our-company.vision-mission');
    }

    public function careers(){
        return view('front.careers');
    }
    public function clients(){
        $projects = Project::where('active', 1)->latest()->get();
        $clients = Client::where('active', 1)->orderBy('name', 'asc')->get();
        return view('front.clients', compact('projects','clients'));
    }
    public function contact(){
        return view('front.contact');
    }
    public function newsDetails(){
        return view('front.news-details');
    }
    public function news(){
        return view('front.news');
    }
    public function projectDetails(){
        return view('front.project-details');
    }
    public function project(){
        $projects = Project::where('active', 1)->latest()->get();
        $clients = Client::where('active', 1)->latest()->get();


        $ongoings = [];
        $completes = [];
        foreach ($projects as $project) {
            if ($project->status) {
                foreach ($clients as $client) {
                    $completes += [$client->id => []];
                    if ($project->client_id == $client->id) {
                        array_push($completes[$client->id], $project);
                    }
                }
            }else{
                foreach ($clients as $client) {
                    $ongoings += [$client->id => []];
                    if ($project->client_id == $client->id) {
                        array_push($ongoings[$client->id], $project);
                    }
                }
            }
        }

        // return $completes;

        return view('front.project', compact('ongoings', 'completes','clients'));
    }
    public function resources(){
        return view('front.resources');
    }
    // public function services(){
    //     return view('front.services');
    // }
    public function edds(){
        return view('front.services.edds');
    }
    public function it(){
        return view('front.services.it');
    }
    public function others(){
        return view('front.services.others');
    }
    

    // public function merch(Request $request, $id){
    //     $product = Product::findOrFail($id);
    // 	return view('front.merch', compact('product'));
    // 	// return view('front.merch', compact('product'));
    // }

    // public function product(){
    //     return view('front.product');
    // }

    // public function payment(Request $request){
    //     if (!Auth::check()) {
    //         return redirect('/user/login')->with('warning', 'Please login first!');
    //     }
    //     // return $request;
    //     session()->put('order',[
    //         'product_name' => $request->product_name,
    //         'qty' => $request->qty,
    //         'promo_code' => $request->promo_code,
    //         'size' => $request->size,
    //         'product_id' => $request->product_id,
    //         'discounted' => $request->discounted,
    //     ]);
    //     // return session('order');
    //     $product = Product::findOrFail($request->product_id,);
    //     return view('front.payment', compact('product'));
    // }

    // public function order(Request $request){
        
    //     $request->validate([
    //         'bill_name' => 'required',
    //         'bill_phone' => 'required',
    //         'bill_email' => 'required|email',
    //         'bill_address' => 'required',
    //         'terms' => 'required'
    //     ]);
    //     session()->put('bill_details',[
    //         'bill_name' => $request->bill_name,
    //         'bill_phone' => $request->bill_phone,
    //         'bill_email' => $request->bill_email,
    //         'bill_address' => $request->bill_address,
    //     ]);

    //     return redirect('select-payment');

    // }

    // public function selectPayment(Request $request){
    //     if (Auth::check()) {
    //         $intent = auth()->user()->createSetupIntent();
    //     }else{
    //         return redirect('/user/login')->with('warning', 'Please login first!');
    //     }

    //     $product = Product::findorFail(session('order')['product_id']);
    // 	return view('front.select-payment', compact('intent', 'product'));
    // 	// return view('front.select-payment');
    // }
    


    // public function corrugated(){
    //     return view('front.corrugated');
    // }


    // public function product_details($title){
    //     $product = Product::where('name', str_replace('_', ' ', $title))->firstOrFail();
    // 	return view('front.product-single', compact('product'));
    // }

    // public function contact(){
    // 	return view('front.contact');
    // }

    // public function blog(){
    //     $blogs = Blog::latest()->paginate(2);
    //     $tags = Tag::latest()->get();
    //     $news = News::latest()->limit(5)->get();
    //     $archives = Blog::latest()->get();
    // 	return view('front.blog', compact('blogs', 'tags', 'news', 'archives'));
    // }

    // public function blog_details($title){
    //     $blog = Blog::where('title', 'LIKE', '%'.str_replace(['_', '`'],[' ', '/'], $title).'%')->firstOrFail();
    //     $tags = Tag::latest()->get();
    //     $next =  Blog::where('id', '>', $blog->id)->orderBy('id')->first();
    //     $prev =  Blog::where('id', '<', $blog->id)->orderBy('id')->first();
    // 	return view('front.blog-single', compact('blog', 'tags', 'next', 'prev'));
    // }

    // public function news(){
    //     $news = News::latest()->get();
    // 	return view('front.news', compact('news'));
    // }

    // public function news_details($title){
    //     $newpost = News::where('title', 'LIKE', '%'.str_replace(['_', '`'],[' ', '/'], $title).'%')->firstOrFail();
    //     $tags = Tag::latest()->get();
    //     $next =  News::where('id', '>', $newpost->id)->orderBy('id')->first();
    //     $prev =  News::where('id', '<', $newpost->id)->orderBy('id')->first();
    // 	$news = News::where('id', '!=', $newpost->id)->latest()->limit(5)->get();
    //     $archives = News::latest()->get();
    //     return view('front.news-single', compact('newpost', 'tags', 'prev', 'next', 'news', 'archives'));
    // }

    // public function events(){
    //     $events = Event::latest()->get();
    //     $tags = Tag::latest()->get();
    // 	return view('front.events', compact('events', 'tags'));
    // }

    // public function events_details($title){
    //     $event = Event::where('title', 'LIKE', '%'.str_replace(['_', '`'],[' ', '/'], $title).'%')->firstOrFail();
    //     $tags = Tag::latest()->get();
    //     $next =  Event::where('id', '>', $event->id)->orderBy('id')->first();
    //     $prev =  Event::where('id', '<', $event->id)->orderBy('id')->first();
    //     $news = News::latest()->limit(5)->get();
    //     $events = Event::latest()->limit(5)->get();
    //     $archives = Event::latest()->get();
    // 	return view('front.events-single', compact('event','events', 'tags', 'next', 'prev', 'news', 'archives'));
    // }

    // public function filter_tag(Request $request){
    //     $tag = Tag::findOrFail($request->id);

    //     $searchResults = (new Search())
    //        ->registerModel(News::class, 'tag_id')
    //        ->registerModel(Event::class, 'tag_id')
    //        ->registerModel(Blog::class, 'tag_id')
    //        ->search($tag->id);

    //     $keyword = $tag->name;
    //     return view('front.search', compact('searchResults', 'keyword'));
    // }

    // public function search(Request $request){
    //     $searchResults = (new Search())
    //        ->registerModel(News::class, 'title', 'description' )
    //        ->registerModel(Event::class, 'title', 'description' )
    //        ->registerModel(Blog::class, 'title', 'description', 'client')
    //        ->search($request->keyword);

    //     $keyword = $request->keyword;
    //     return view('front.search', compact('searchResults', 'keyword'));
    // }
}
