<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\Product;
use App\Models\Order;
use App\Http\Controllers\CalculationController as Calculate;
use Laravel\Cashier\Cashier;


class StripeController extends Controller
{
    public function stripeCheckout(Request $request)
    {

        $order = (object) session('order');
    
        $product = Product::find($order->product_id);
        $bill_details = (object) session('bill_details');
        
        $discount = 0;
        if (in_array($order->promo_code, ['HeySexy15','TheDreWay']) ) {
            $discount = .15;
        }
        
        $price = new Calculate($product->price, $order->qty, $discount);
        
        // return $request;
        $stripeCharge = null;
        
        
        
        
        try {
            $order = (object) session('order');
            $product = Product::find($order->product_id);
            
            $user = Cashier::findBillable($request->user()->stripe_id);

            if (!$user) {
                $request->user()->createAsStripeCustomer();
            }

            if ($request->user()->hasPaymentMethod()) {
                // return  $request->user()->paymentMethods()[0]->id;
                $stripeCharge = $request->user()->charge(
                    $price->total() * 100, $request->user()->paymentMethods()[0]->id, [
                        'description' => 'test',
                    ]
                );
            }else {
                $request->user()->addPaymentMethod($request->payment_method);
                $stripeCharge = $request->user()->charge(
                    $price->total() * 100, $request->user()->paymentMethods()[0]->id, [
                        'description' => 'test',
                    ]
                );
            }

            // return $product->price;
            // return $request->user()->checkoutCharge(120, $order->product_name, $order->qty, [
            //     'success_url' =>  url('/stripe-success'),
            //     'cancel_url' => url('/stripe-cancel'),
            // ]);
            // return 

            // return $stripeCharge;
        } catch (Exception $e) {
            return back()->with('warning', 'Invalid payment!');
        }

        // return $stripeCharge->status;
        if ($stripeCharge->status == 'succeeded') {
            return redirect('stripe-success');
        }else{
            return back()->with('warning', 'Invalid payment!');
        }

       
    }
    public function stripeSuccess(Request $request){
        // return $request;
        try {
            
            $order = (object) session('order');
    
            $product = Product::find($order->product_id);
            $bill_details = (object) session('bill_details');
    
            $discount = 0;
            if (in_array($order->promo_code, ['HeySexy15','TheDreWay']) ) {
                $discount = .15;
            }
    
            $price = new Calculate($product->price, $order->qty, $discount);
            
            $items = [
                [
                    "name"=> $order->product_name." - ".$order->size,
                    "price" => $product->price,
                    "currency" => "USD",
                    // "tax" => "0.00",
                    "quantity" => $order->qty,
                ]
            ];
    
            Order::create([
                'user_id' => \Auth::check() ? auth()->user()->id : null,
                'order_no' => 'TD-ODR-' . date('Ymdh') . Order::count() + 1,
                'bill_name' => $bill_details->bill_name,
                'bill_email' => $bill_details->bill_email,
                'bill_mobile' => $bill_details->bill_phone,
                'bill_address' => $bill_details->bill_address,
                'payment_method' => 'stripe',
                'payment_reference' => '',
                'payment_status' => 'approved',
                'order_items' => json_encode($items),
                'promo_code' => $order->promo_code,
                'discount' => $discount,
                // 'card_fee' => ,
                // 'status' => $status,
                'total_amount_due' => number_format($price->total(), 2),
                'discounted' => number_format(($price->total() * $discount) * $order->qty , 2),
            ]);
        } catch (\Throwable $th) {
            // throw $th;
            return back()->with('warning', 'Failed Purchased!');
        }


        return redirect('/')->with('success', 'Successfully Purchased!');
    }
    
}